/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.tld;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.web.core.syntax.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class LibraryDescriptor {
    private FileObject definitionFile;
    private InputStream content;
    protected String prefix;
    protected String uri;
    protected String displayName;
    protected Map<String, Tag> tags = new HashMap<String, Tag>();
    protected Map<String, Function> functions = new HashMap<String, Function>();
    private static final String STOP_PARSING_MGS = "regularly_stopped";

    protected LibraryDescriptor() {
    }

    protected LibraryDescriptor(FileObject definitionFile) throws LibraryDescriptorException {
        this.definitionFile = definitionFile;
    }

    protected LibraryDescriptor(InputStream content) throws LibraryDescriptorException {
        this.content = content;
    }

    public FileObject getDefinitionFile() {
        return this.definitionFile;
    }

    public String getURI() {
        return this.uri;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, Tag> getTags() {
        return this.tags;
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    protected void parseLibrary() throws LibraryDescriptorException {
        try {
            this.parseLibrary(this.getDefinitionFile().getInputStream());
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected abstract void parseLibrary(InputStream var1) throws LibraryDescriptorException;

    protected static String parseNamespace(InputStream content, final String tagTagName, final String namespaceTagName) {
        String[] ns;
        block4: {
            ns = new String[1];
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                SAXParser parser = factory.newSAXParser();
                class Handler
                extends DefaultHandler {
                    private boolean inTaglib = false;
                    private boolean inURI = false;

                    Handler() {
                    }

                    @Override
                    public void startElement(String uri, String localname, String qname, Attributes attr) throws SAXException {
                        String tagName = qname.toLowerCase();
                        if (tagTagName.equals(tagName)) {
                            this.inTaglib = true;
                        }
                        if (this.inTaglib && namespaceTagName.equals(tagName)) {
                            this.inURI = true;
                        }
                    }

                    @Override
                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.inURI) {
                            ns[0] = new String(ch, start, length).trim();
                            throw new SAXException(LibraryDescriptor.STOP_PARSING_MGS);
                        }
                    }

                    @Override
                    public InputSource resolveEntity(String publicId, String systemId) {
                        return new InputSource(new StringReader(""));
                    }
                }
                parser.parse(content, (DefaultHandler)new Handler());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ParserConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SAXException ex) {
                if (STOP_PARSING_MGS.equals(ex.getMessage())) break block4;
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return ns[0];
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDefinitionFile() != null ? this.getDefinitionFile().getFileSystem().getRoot().getURL().toString() + ";" + this.getDefinitionFile().getPath() : "");
            sb.append("; defaultPrefix = " + this.getDefaultPrefix() + "; uri = " + this.getURI() + "; tags={");
            for (Tag t : this.getTags().values()) {
                sb.append(t.toString());
            }
            sb.append("}]");
            return sb.toString();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    protected static String getTextContent(Node parent, String childName) {
        Node found = LibraryDescriptor.getNodeByName(parent, childName);
        return found == null ? null : found.getTextContent().trim();
    }

    protected static Node getNodeByName(Node parent, String childName) {
        Collection<Node> found = LibraryDescriptor.getNodesByName(parent, childName);
        if (!found.isEmpty()) {
            return found.iterator().next();
        }
        return null;
    }

    protected static Collection<Node> getNodesByName(Node parent, String childName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList nl = parent.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNodeName().equals(childName)) continue;
            nodes.add(n);
        }
        return nodes;
    }

    public static class FunctionImpl
    implements Function {
        private String name;
        private String signature;
        private String desc;
        private String example;

        public FunctionImpl(String name, String signature, String desc, String example) {
            this.name = name;
            this.signature = signature;
            this.desc = desc;
            this.example = example;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public String getExample() {
            return this.example;
        }

        public String toString() {
            return "Function[name=" + this.getName() + ", signature" + this.getSignature() + "]";
        }
    }

    public static class Attribute {
        private String name;
        private String description;
        private boolean required;

        public Attribute(String name, String description, boolean required) {
            this.name = name;
            this.description = description;
            this.required = required;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "Attribute[name=" + this.getName() + ", required=" + this.isRequired() + "]";
        }
    }

    public static class TagImpl
    implements Tag {
        private static final String ID_ATTR_NAME = "id";
        private String name;
        private String description;
        private Map<String, Attribute> attrs;

        public TagImpl(String name, String description, Map<String, Attribute> attrs) {
            this.name = name;
            this.description = description;
            this.attrs = attrs;
            if (this.getAttribute(ID_ATTR_NAME) == null) {
                attrs.put(ID_ATTR_NAME, new Attribute(ID_ATTR_NAME, "", false));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean hasNonGenenericAttributes() {
            return this.getAttributes().size() > 1;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            return this.attrs.values();
        }

        @Override
        public Attribute getAttribute(String name) {
            return this.attrs.get(name);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Tag[name=" + this.getName() + ", attributes={");
            for (Attribute attr : this.getAttributes()) {
                sb.append(attr.toString() + ",");
            }
            sb.append("}]");
            return sb.toString();
        }
    }

    public static interface Function {
        public String getName();

        public String getSignature();

        public String getDescription();

        public String getExample();
    }

    public static interface Tag {
        public String getName();

        public String getDescription();

        public boolean hasNonGenenericAttributes();

        public Collection<Attribute> getAttributes();

        public Attribute getAttribute(String var1);
    }
}

