/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.ui.branding.AbstractBrandingPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class BasicBrandingPanel
extends AbstractBrandingPanel {
    private final SortedMap<Integer, URL> iconSources = IntStream.of(16, 32, 48, 256, 512, 1024).boxed().collect(Collectors.toMap(size -> size, model::getIconSource, (a, b) -> a, TreeMap::new));
    private boolean titleValueModified;
    private JButton browse;
    private JPanel preview;
    private JList<Map.Entry<Integer, URL>> sizeList;
    private JLabel title;
    private JTextField titleValue;

    public BasicBrandingPanel(BrandingModel model) {
        super(NbBundle.getMessage(BasicBrandingPanel.class, (String)"LBL_BasicTab"), model);
        this.initComponents();
        DefaultListModel listModel = new DefaultListModel();
        this.iconSources.entrySet().forEach(listModel::addElement);
        this.sizeList.setModel(listModel);
        this.sizeList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel ret = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Integer size = (Integer)((Map.Entry)value).getKey();
                ret.setText(String.format("Application Icon (%dx%d)", size, size));
                return ret;
            }
        });
        this.sizeList.setSelectedIndex(0);
        this.refresh();
        this.checkValidity();
        UIUtil.DocumentAdapter textFieldChangeListener = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                BasicBrandingPanel.this.checkValidity();
                BasicBrandingPanel.this.setModified();
                BasicBrandingPanel.this.titleValueModified = true;
            }
        };
        this.titleValue.getDocument().addDocumentListener(textFieldChangeListener);
        this.titleValueModified = false;
    }

    protected void checkValidity() {
        boolean panelValid = true;
        if (panelValid && this.titleValue.getText().trim().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(BasicBrandingPanel.class, (String)"ERR_EmptyTitle"));
            panelValid = false;
        }
        if (panelValid) {
            this.setErrorMessage(null);
        }
        this.setValid(panelValid);
    }

    void refresh() {
        BrandingModel model = this.getBranding();
        model.brandingEnabledRefresh();
        model.initTitle(true);
        this.titleValue.setText(model.getTitle());
        this.browse.setEnabled(model.isBrandingEnabled());
        this.titleValue.setEnabled(model.isBrandingEnabled());
    }

    @Override
    public void store() {
        if (this.titleValueModified) {
            this.getBranding().setTitle(this.titleValue.getText());
        }
        this.iconSources.entrySet().forEach(e -> this.getBranding().setIconSource((Integer)e.getKey(), (URL)e.getValue()));
    }

    private void setPreview(URL res) {
        try {
            BufferedImage img = ImageIO.read(res);
            ((ImagePreview)this.preview).setImage(img);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.title = new JLabel();
        this.titleValue = new JTextField();
        JScrollPane listScrollPane = new JScrollPane();
        this.sizeList = new JList();
        this.browse = new JButton();
        JScrollPane previewScrollPane = new JScrollPane();
        this.preview = new ImagePreview();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/branding/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.title, (String)bundle.getString("LBL_AppTitle"));
        this.titleValue.setColumns(20);
        this.sizeList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                BasicBrandingPanel.this.sizeListValueChanged(evt);
            }
        });
        listScrollPane.setViewportView(this.sizeList);
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(BasicBrandingPanel.class, (String)"CTL_Browse"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicBrandingPanel.this.browseActionPerformed(evt);
            }
        });
        GroupLayout previewLayout = new GroupLayout(this.preview);
        this.preview.setLayout(previewLayout);
        previewLayout.setHorizontalGroup(previewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1058, Short.MAX_VALUE));
        previewLayout.setVerticalGroup(previewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 1898, Short.MAX_VALUE));
        previewScrollPane.setViewportView(this.preview);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.title, -2, 170, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleValue)).addGroup(layout.createSequentialGroup().addComponent(listScrollPane, -2, 264, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.browse).addComponent(previewScrollPane, -1, 319, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.title).addComponent(this.titleValue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.browse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(previewScrollPane, -1, 389, Short.MAX_VALUE)).addComponent(listScrollPane)).addContainerGap()));
        this.title.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicBrandingPanel.class, (String)"ACS_Title"));
        this.browse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BasicBrandingPanel.class, (String)"ACS_Browse"));
    }

    private void sizeListValueChanged(ListSelectionEvent evt) {
        this.setPreview(this.sizeList.getSelectedValue().getValue());
    }

    private void browseActionPerformed(ActionEvent evt) {
        URL res = this.browseIcon();
        this.setPreview(res);
        this.setModified();
        this.sizeList.getSelectedValue().setValue(res);
    }

    private URL browseIcon() {
        URL res = null;
        JFileChooser chooser = UIUtil.getIconFileChooser();
        int ret = chooser.showDialog(this, NbBundle.getMessage(this.getClass(), (String)"LBL_Select"));
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            try {
                res = Utilities.toURI((File)file).toURL();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return res;
    }

    private static class ImagePreview
    extends JPanel {
        private BufferedImage image = new BufferedImage(10, 10, 1);

        private ImagePreview() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.image, 0, 0, this.image.getWidth(), this.image.getHeight(), this);
        }

        public void setImage(BufferedImage image) {
            this.image = image;
            this.revalidate();
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.image.getWidth(), this.image.getHeight());
        }
    }
}

