/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.BuildRun;
import com.oracle.bmc.devops.requests.CreateBuildRunRequest;
import com.oracle.bmc.devops.responses.CreateBuildRunResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuildRunConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateBuildRunConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateBuildRunRequest interceptRequest(CreateBuildRunRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateBuildRunRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateBuildRunDetails(), (String)"createBuildRunDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("buildRuns");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, CreateBuildRunResponse> fromResponse() {
        Function<Response, CreateBuildRunResponse> transformer = new Function<Response, CreateBuildRunResponse>(){

            public CreateBuildRunResponse apply(Response rawResponse) {
                Optional locationHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.CreateBuildRunResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(BuildRun.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateBuildRunResponse.Builder builder = CreateBuildRunResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.buildRun((BuildRun)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"location")).isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                CreateBuildRunResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

