/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.html.editor.hints.EmbeddingUtil;
import org.netbeans.modules.html.editor.hints.HtmlRuleContext;
import org.netbeans.modules.html.editor.hints.css.Bundle;
import org.netbeans.modules.html.editor.hints.css.CssElementType;
import org.netbeans.modules.html.editor.hints.css.HintContext;
import org.netbeans.modules.html.editor.hints.css.MissingCssElement;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;

public class CssClassesVisitor
implements ElementVisitor {
    static Pattern CLASSES_PATTERN = Pattern.compile("\\s+");
    private static final String CLASS_ATTR_NAME = "class";
    private final HtmlRuleContext context;
    private final Collection<FileObject> referredFiles;
    private final Collection<FileObject> allStylesheets;
    private final Map<FileObject, Collection<String>> classes;
    private final Map<String, Collection<FileObject>> classes2files;
    private final Rule rule;
    private final List<Hint> hints;

    public CssClassesVisitor(Rule rule, HtmlRuleContext context, List<Hint> hints) throws IOException {
        this.context = context;
        this.hints = hints;
        this.rule = rule;
        this.referredFiles = context.getCssDependenciesGraph().getAllReferedFiles();
        this.classes = context.getCssIndex().findAllClassDeclarations();
        this.classes2files = CssClassesVisitor.createReversedMap(this.classes);
        this.allStylesheets = context.getCssIndex().getAllIndexedFiles();
    }

    private static Map<String, Collection<FileObject>> createReversedMap(Map<FileObject, Collection<String>> file2elements) {
        HashMap<String, Collection<FileObject>> map = new HashMap<String, Collection<FileObject>>();
        for (FileObject file : file2elements.keySet()) {
            for (String element : file2elements.get(file)) {
                HashSet<FileObject> files = (HashSet<FileObject>)map.get(element);
                if (files == null) {
                    files = new HashSet<FileObject>();
                }
                files.add(file);
                map.put(element, files);
            }
        }
        return map;
    }

    public void visit(Element node) {
        OpenTag tag = (OpenTag)node;
        for (Attribute id : tag.attributes(new AttributeFilter(){

            public boolean accepts(Attribute attribute) {
                return LexerUtils.equals((CharSequence)CssClassesVisitor.CLASS_ATTR_NAME, (CharSequence)attribute.name(), (boolean)true, (boolean)true);
            }
        })) {
            this.processElements(id, CssElementType.CLASS);
        }
    }

    private void processElements(Attribute attribute, CssElementType elementType) {
        CharSequence value = attribute.unquotedValue();
        if (value == null) {
            return;
        }
        if (value.length() == 0) {
            return;
        }
        for (String token : CLASSES_PATTERN.split(value)) {
            String trimmed = token.trim();
            if (trimmed.isEmpty() || "@@@".equals(trimmed)) continue;
            Collection<FileObject> filesWithTheClass = this.classes2files.get(token);
            LinkedList<FileObject> referredFilesWithTheId = new LinkedList<FileObject>();
            if (filesWithTheClass != null) {
                referredFilesWithTheId.addAll(filesWithTheClass);
                referredFilesWithTheId.retainAll(this.referredFiles);
            }
            if (!referredFilesWithTheId.isEmpty()) continue;
            this.hints.add(new MissingCssElement(this.rule, Bundle.MissingCssClass(token), this.context, CssClassesVisitor.getAttributeValueOffsetRange(attribute, this.context), new HintContext(token, '.' + token, this.referredFiles, this.allStylesheets, this.classes, this.classes2files)));
        }
    }

    private static OffsetRange getAttributeValueOffsetRange(Attribute attr, HtmlRuleContext context) {
        boolean quoted = attr.isValueQuoted();
        int from = attr.valueOffset() + (quoted ? 1 : 0);
        int to = from + attr.unquotedValue().length();
        return EmbeddingUtil.convertToDocumentOffsets(from, to, context.getSnapshot());
    }
}

