/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec2(13, 26) >> 0u) => ivec2(13, 26)
 * (ivec2(13, 26) >> 1u) => ivec2(6, 13)
 * (ivec2(13, 26) >> 2u) => ivec2(3, 6)
 * (ivec2(13, 26) >> 5u) => ivec2(0, 0)
 * (ivec2(13, 26) >> 25u) => ivec2(0, 0)
 * (ivec2(13, 26) >> 31u) => ivec2(0, 0)
 * (ivec2(-2, 26) >> 0u) => ivec2(-2, 26)
 * (ivec2(-2, 26) >> 1u) => ivec2(-1, 13)
 * (ivec2(-2, 26) >> 2u) => ivec2(-1, 6)
 * (ivec2(-2, 26) >> 5u) => ivec2(-1, 0)
 * (ivec2(-2, 26) >> 25u) => ivec2(-1, 0)
 * (ivec2(-2, 26) >> 31u) => ivec2(-1, 0)
 * (ivec2(2, 26) >> 0u) => ivec2(2, 26)
 * (ivec2(2, 26) >> 1u) => ivec2(1, 13)
 * (ivec2(2, 26) >> 2u) => ivec2(0, 6)
 * (ivec2(2, 26) >> 5u) => ivec2(0, 0)
 * (ivec2(2, 26) >> 25u) => ivec2(0, 0)
 * (ivec2(2, 26) >> 31u) => ivec2(0, 0)
 */
#version 130

void main()
{
  float[all(equal((ivec2(13, 26) >> 0u), ivec2(13, 26))) ? 1 : -1] array0;
  float[all(equal((ivec2(13, 26) >> 1u), ivec2(6, 13))) ? 1 : -1] array1;
  float[all(equal((ivec2(13, 26) >> 2u), ivec2(3, 6))) ? 1 : -1] array2;
  float[all(equal((ivec2(13, 26) >> 5u), ivec2(0, 0))) ? 1 : -1] array3;
  float[all(equal((ivec2(13, 26) >> 25u), ivec2(0, 0))) ? 1 : -1] array4;
  float[all(equal((ivec2(13, 26) >> 31u), ivec2(0, 0))) ? 1 : -1] array5;
  float[all(equal((ivec2(-2, 26) >> 0u), ivec2(-2, 26))) ? 1 : -1] array6;
  float[all(equal((ivec2(-2, 26) >> 1u), ivec2(-1, 13))) ? 1 : -1] array7;
  float[all(equal((ivec2(-2, 26) >> 2u), ivec2(-1, 6))) ? 1 : -1] array8;
  float[all(equal((ivec2(-2, 26) >> 5u), ivec2(-1, 0))) ? 1 : -1] array9;
  float[all(equal((ivec2(-2, 26) >> 25u), ivec2(-1, 0))) ? 1 : -1] array10;
  float[all(equal((ivec2(-2, 26) >> 31u), ivec2(-1, 0))) ? 1 : -1] array11;
  float[all(equal((ivec2(2, 26) >> 0u), ivec2(2, 26))) ? 1 : -1] array12;
  float[all(equal((ivec2(2, 26) >> 1u), ivec2(1, 13))) ? 1 : -1] array13;
  float[all(equal((ivec2(2, 26) >> 2u), ivec2(0, 6))) ? 1 : -1] array14;
  float[all(equal((ivec2(2, 26) >> 5u), ivec2(0, 0))) ? 1 : -1] array15;
  float[all(equal((ivec2(2, 26) >> 25u), ivec2(0, 0))) ? 1 : -1] array16;
  float[all(equal((ivec2(2, 26) >> 31u), ivec2(0, 0))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
