/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * lessThan(uvec2(0u, 0u), uvec2(0u, 1u)) => bvec2(false, true)
 * lessThan(uvec2(0u, 0u), uvec2(2u, 5u)) => bvec2(true, true)
 * lessThan(uvec2(0u, 1u), uvec2(34u, 0u)) => bvec2(true, false)
 * lessThan(uvec2(1u, 1u), uvec2(1u, 2u)) => bvec2(false, true)
 * lessThan(uvec2(1u, 1u), uvec2(5u, 34u)) => bvec2(true, true)
 * lessThan(uvec2(2u, 2u), uvec2(0u, 1u)) => bvec2(false, false)
 * lessThan(uvec2(2u, 2u), uvec2(2u, 5u)) => bvec2(false, true)
 * lessThan(uvec2(2u, 5u), uvec2(34u, 0u)) => bvec2(true, false)
 * lessThan(uvec2(5u, 5u), uvec2(1u, 2u)) => bvec2(false, false)
 * lessThan(uvec2(5u, 5u), uvec2(5u, 34u)) => bvec2(false, true)
 * lessThan(uvec2(34u, 34u), uvec2(0u, 1u)) => bvec2(false, false)
 * lessThan(uvec2(34u, 34u), uvec2(2u, 5u)) => bvec2(false, false)
 * lessThan(uvec2(34u, 0u), uvec2(34u, 0u)) => bvec2(false, false)
 */
#version 150

void main()
{
  float[all(equal(lessThan(uvec2(0u, 0u), uvec2(0u, 1u)), bvec2(false, true))) ? 1 : -1] array0;
  float[all(equal(lessThan(uvec2(0u, 0u), uvec2(2u, 5u)), bvec2(true, true))) ? 1 : -1] array1;
  float[all(equal(lessThan(uvec2(0u, 1u), uvec2(34u, 0u)), bvec2(true, false))) ? 1 : -1] array2;
  float[all(equal(lessThan(uvec2(1u, 1u), uvec2(1u, 2u)), bvec2(false, true))) ? 1 : -1] array3;
  float[all(equal(lessThan(uvec2(1u, 1u), uvec2(5u, 34u)), bvec2(true, true))) ? 1 : -1] array4;
  float[all(equal(lessThan(uvec2(2u, 2u), uvec2(0u, 1u)), bvec2(false, false))) ? 1 : -1] array5;
  float[all(equal(lessThan(uvec2(2u, 2u), uvec2(2u, 5u)), bvec2(false, true))) ? 1 : -1] array6;
  float[all(equal(lessThan(uvec2(2u, 5u), uvec2(34u, 0u)), bvec2(true, false))) ? 1 : -1] array7;
  float[all(equal(lessThan(uvec2(5u, 5u), uvec2(1u, 2u)), bvec2(false, false))) ? 1 : -1] array8;
  float[all(equal(lessThan(uvec2(5u, 5u), uvec2(5u, 34u)), bvec2(false, true))) ? 1 : -1] array9;
  float[all(equal(lessThan(uvec2(34u, 34u), uvec2(0u, 1u)), bvec2(false, false))) ? 1 : -1] array10;
  float[all(equal(lessThan(uvec2(34u, 34u), uvec2(2u, 5u)), bvec2(false, false))) ? 1 : -1] array11;
  float[all(equal(lessThan(uvec2(34u, 0u), uvec2(34u, 0u)), bvec2(false, false))) ? 1 : -1] array12;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length());
}
