/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.convert.TSimpleFormatConversionProvider;

public abstract class TEncodingFormatConversionProvider
extends TSimpleFormatConversionProvider {
    protected TEncodingFormatConversionProvider(Collection sourceFormats, Collection targetFormats) {
        super(sourceFormats, targetFormats);
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TEncodingFormatConversionProvider.getTargetFormats(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to: " + targetEncoding);
        }
        if (this.isConversionSupported(targetEncoding, sourceFormat)) {
            ArraySet result = new ArraySet();
            Iterator iterator = this.getCollectionTargetFormats().iterator();
            while (iterator.hasNext()) {
                AudioFormat targetFormat = (AudioFormat)iterator.next();
                targetFormat = this.replaceNotSpecified(sourceFormat, targetFormat);
                result.add(targetFormat);
            }
            if (TDebug.TraceAudioConverter) {
                TDebug.out("< returning " + result.size() + " elements.");
            }
            return result.toArray(EMPTY_FORMAT_ARRAY);
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("< returning empty array.");
        }
        return EMPTY_FORMAT_ARRAY;
    }
}

