/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.protocol.message.extension.TokenBindingExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.TokenBindingExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;

public class TokenBindingExtensionPreparator
extends ExtensionPreparator<TokenBindingExtensionMessage> {
    private final TokenBindingExtensionMessage message;

    public TokenBindingExtensionPreparator(Chooser chooser, TokenBindingExtensionMessage message, TokenBindingExtensionSerializer serializer) {
        super(chooser, message, serializer);
        this.message = message;
    }

    @Override
    public void prepareExtensionContent() {
        this.message.setTokenbindingVersion(this.chooser.getConfig().getDefaultTokenBindingVersion().getByteValue());
        ByteArrayOutputStream tokenbindingKeyParameters = new ByteArrayOutputStream();
        for (TokenBindingKeyParameters kp : this.chooser.getConfig().getDefaultTokenBindingKeyParameters()) {
            tokenbindingKeyParameters.write(kp.getValue());
        }
        this.message.setTokenbindingKeyParameters(tokenbindingKeyParameters.toByteArray());
        this.message.setParameterListLength(((byte[])this.message.getTokenbindingKeyParameters().getValue()).length);
    }
}

