/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.JDBCEnvironment;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.apache.ibatis.datasource.unpooled.UnpooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DynamicallyAuthenticatedDataSource
extends PooledDataSource {
    private static final Logger logger = LoggerFactory.getLogger(DynamicallyAuthenticatedDataSource.class);

    @Inject
    public DynamicallyAuthenticatedDataSource(final JDBCEnvironment environment, @Named(value="JDBC.driverClassLoader") ClassLoader driverClassLoader, @Named(value="JDBC.driver") String driver, @Named(value="JDBC.url") String url) {
        super(new UnpooledDataSource(driverClassLoader, driver, url, null, null){

            @Override
            public Connection getConnection() throws SQLException {
                try {
                    logger.debug("Creating new database connection for pool.");
                    return super.getConnection(environment.getUsername(), environment.getPassword());
                }
                catch (GuacamoleException e) {
                    throw new SQLException("Retrieval of database credentials failed.", e);
                }
            }
        });
        super.forceCloseAll();
    }

    @Override
    @Inject(optional=true)
    public void setPoolPingConnectionsNotUsedFor(@Named(value="mybatis.pooled.pingConnectionsNotUsedFor") int milliseconds) {
        super.setPoolPingConnectionsNotUsedFor(milliseconds);
    }

    @Override
    @Inject(optional=true)
    public void setPoolPingEnabled(@Named(value="mybatis.pooled.pingEnabled") boolean poolPingEnabled) {
        super.setPoolPingEnabled(poolPingEnabled);
    }

    @Override
    @Inject(optional=true)
    public void setPoolPingQuery(@Named(value="mybatis.pooled.pingQuery") String poolPingQuery) {
        super.setPoolPingQuery(poolPingQuery);
    }

    @Override
    @Inject(optional=true)
    public void setPoolTimeToWait(@Named(value="mybatis.pooled.timeToWait") int poolTimeToWait) {
        super.setPoolTimeToWait(poolTimeToWait);
    }

    @Override
    @Inject(optional=true)
    public void setPoolMaximumCheckoutTime(@Named(value="mybatis.pooled.maximumCheckoutTime") int poolMaximumCheckoutTime) {
        super.setPoolMaximumCheckoutTime(poolMaximumCheckoutTime);
    }

    @Override
    @Inject(optional=true)
    public void setPoolMaximumIdleConnections(@Named(value="mybatis.pooled.maximumIdleConnections") int poolMaximumIdleConnections) {
        super.setPoolMaximumIdleConnections(poolMaximumIdleConnections);
    }

    @Override
    @Inject(optional=true)
    public void setPoolMaximumActiveConnections(@Named(value="mybatis.pooled.maximumActiveConnections") int poolMaximumActiveConnections) {
        super.setPoolMaximumActiveConnections(poolMaximumActiveConnections);
    }

    @Override
    @Inject(optional=true)
    public void setDriverProperties(@Named(value="JDBC.driverProperties") Properties driverProps) {
        super.setDriverProperties(driverProps);
    }

    @Override
    @Inject(optional=true)
    public void setDefaultAutoCommit(@Named(value="JDBC.autoCommit") boolean defaultAutoCommit) {
        super.setDefaultAutoCommit(defaultAutoCommit);
    }

    @Override
    @Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        super.setLoginTimeout(loginTimeout);
    }
}

