/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.permission;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.permission.SystemPermissionService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.permission.SystemPermission;

public class SystemPermissionSet
extends RestrictedObject
implements org.apache.guacamole.net.auth.permission.SystemPermissionSet {
    private ModeledPermissions<? extends EntityModel> entity;
    private Set<String> effectiveGroups;
    @Inject
    private SystemPermissionService systemPermissionService;

    public void init(ModeledAuthenticatedUser currentUser, ModeledPermissions<? extends EntityModel> entity, Set<String> effectiveGroups) {
        super.init(currentUser);
        this.entity = entity;
        this.effectiveGroups = effectiveGroups;
    }

    public Set<SystemPermission> getPermissions() throws GuacamoleException {
        return this.systemPermissionService.retrievePermissions(this.getCurrentUser(), this.entity, this.effectiveGroups);
    }

    public boolean hasPermission(SystemPermission.Type permission) throws GuacamoleException {
        return this.systemPermissionService.hasPermission(this.getCurrentUser(), this.entity, permission, this.effectiveGroups);
    }

    public void addPermission(SystemPermission.Type permission) throws GuacamoleException {
        this.addPermissions(Collections.singleton(new SystemPermission(permission)));
    }

    public void removePermission(SystemPermission.Type permission) throws GuacamoleException {
        this.removePermissions(Collections.singleton(new SystemPermission(permission)));
    }

    public void addPermissions(Set<SystemPermission> permissions) throws GuacamoleException {
        this.systemPermissionService.createPermissions(this.getCurrentUser(), this.entity, (Collection<SystemPermission>)permissions);
    }

    public void removePermissions(Set<SystemPermission> permissions) throws GuacamoleException {
        this.systemPermissionService.deletePermissions(this.getCurrentUser(), this.entity, (Collection<SystemPermission>)permissions);
    }
}

