/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.json.user.AuthenticatedUser;
import org.apache.guacamole.auth.json.user.UserContext;
import org.apache.guacamole.auth.json.user.UserData;
import org.apache.guacamole.auth.json.user.UserDataService;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

public class AuthenticationProviderService {
    @Inject
    private UserDataService userDataService;
    @Inject
    private Provider<AuthenticatedUser> authenticatedUserProvider;
    @Inject
    private Provider<UserContext> userContextProvider;

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        UserData userData = this.userDataService.fromCredentials(credentials);
        if (userData == null) {
            throw new GuacamoleInvalidCredentialsException("Permission denied.", CredentialsInfo.EMPTY);
        }
        AuthenticatedUser authenticatedUser = this.authenticatedUserProvider.get();
        authenticatedUser.init(credentials, userData);
        return authenticatedUser;
    }

    public UserContext getUserContext(org.apache.guacamole.net.auth.AuthenticatedUser authenticatedUser) throws GuacamoleException {
        if (!(authenticatedUser instanceof AuthenticatedUser)) {
            return null;
        }
        UserContext userContext = this.userContextProvider.get();
        userContext.init(((AuthenticatedUser)authenticatedUser).getUserData());
        return userContext;
    }
}

