/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.authentication;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class AnonymousAuthenticationWebFilter
implements WebFilter {
    private static final Log logger = LogFactory.getLog(AnonymousAuthenticationWebFilter.class);
    private String key;
    private Object principal;
    private List<GrantedAuthority> authorities;

    public AnonymousAuthenticationWebFilter(String key) {
        this(key, "anonymousUser", AuthorityUtils.createAuthorityList("ROLE_ANONYMOUS"));
    }

    public AnonymousAuthenticationWebFilter(String key, Object principal, List<GrantedAuthority> authorities) {
        Assert.hasLength(key, "key cannot be null or empty");
        Assert.notNull(principal, "Anonymous authentication principal must be set");
        Assert.notNull(authorities, "Anonymous authorities must be set");
        this.key = key;
        this.principal = principal;
        this.authorities = authorities;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange2, WebFilterChain chain) {
        return ReactiveSecurityContextHolder.getContext().switchIfEmpty(Mono.defer(() -> {
            Authentication authentication = this.createAuthentication(exchange2);
            SecurityContextImpl securityContext = new SecurityContextImpl(authentication);
            logger.debug(LogMessage.format("Populated SecurityContext with anonymous token: '%s'", (Object)authentication));
            return chain.filter(exchange2).subscriberContext(ReactiveSecurityContextHolder.withSecurityContext((Mono<? extends SecurityContext>)Mono.just((Object)securityContext))).then(Mono.empty());
        })).flatMap(securityContext -> {
            logger.debug(LogMessage.format("SecurityContext contains anonymous token: '%s'", (Object)securityContext.getAuthentication()));
            return chain.filter(exchange2);
        });
    }

    protected Authentication createAuthentication(ServerWebExchange exchange2) {
        return new AnonymousAuthenticationToken(this.key, this.principal, this.authorities);
    }
}

