"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var bbox_calculator_1 = require("./bbox_calculator");
var CanvasTextBBoxCalculator = (function () {
    function CanvasTextBBoxCalculator(rootElement) {
        this.offscreenCanvas = document.createElement('canvas');
        this.offscreenCanvas.style.position = 'absolute';
        this.offscreenCanvas.style.top = '-99999px';
        this.offscreenCanvas.style.left = '-99999px';
        this.context = this.offscreenCanvas.getContext('2d');
        this.attachedRoot = rootElement || document.documentElement;
        this.attachedRoot.appendChild(this.offscreenCanvas);
    }
    CanvasTextBBoxCalculator.prototype.compute = function (text, padding, fontSize, fontFamily, lineHeight, fontWeight) {
        if (fontSize === void 0) { fontSize = 16; }
        if (fontFamily === void 0) { fontFamily = 'Arial'; }
        if (lineHeight === void 0) { lineHeight = 1; }
        if (fontWeight === void 0) { fontWeight = 400; }
        if (!this.context) {
            return bbox_calculator_1.DEFAULT_EMPTY_BBOX;
        }
        if (padding < 1) {
            padding = 1;
        }
        this.context.font = fontWeight + " " + fontSize + "px " + fontFamily;
        var measure = this.context.measureText(text);
        return {
            width: measure.width + padding,
            height: fontSize * lineHeight,
        };
    };
    CanvasTextBBoxCalculator.prototype.destroy = function () {
        this.attachedRoot.removeChild(this.offscreenCanvas);
    };
    return CanvasTextBBoxCalculator;
}());
exports.CanvasTextBBoxCalculator = CanvasTextBBoxCalculator;
//# sourceMappingURL=canvas_text_bbox_calculator.js.map