/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import org.aesh.io.PathResolver;
import org.aesh.io.Resource;
import org.aesh.io.filter.ResourceFilter;

public class FileResource
implements Resource {
    private File file;

    public FileResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cant be null");
        }
        this.file = file;
    }

    public FileResource(Path file) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cant be null");
        }
        this.file = file.toFile();
    }

    public FileResource(String file) {
        if (file == null) {
            throw new IllegalArgumentException("file argument cant be null");
        }
        this.file = new File(file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isLeaf() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(this.file.toPath());
    }

    @Override
    public Resource readSymbolicLink() throws IOException {
        if (this.isSymbolicLink()) {
            return new FileResource(Files.readSymbolicLink(this.file.toPath()).toFile());
        }
        return new FileResource("");
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public void move(Resource target) throws IOException {
        FileResource destination = (FileResource)target;
        Files.move(this.file.toPath(), destination.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public Resource getParent() {
        return new FileResource(this.file.getParentFile());
    }

    @Override
    public List<Resource> list() {
        File[] listFiles;
        ArrayList<Resource> files = new ArrayList<Resource>();
        if (this.file != null && (listFiles = this.file.listFiles()) != null) {
            for (File f : listFiles) {
                files.add(new FileResource(f));
            }
        }
        return files;
    }

    @Override
    public List<Resource> list(ResourceFilter filter) {
        ArrayList<Resource> files = new ArrayList<Resource>();
        for (Resource f : this.list()) {
            if (filter == null || !filter.accept(f)) continue;
            files.add(f);
        }
        return files;
    }

    @Override
    public List<Resource> listRoots() {
        ArrayList<Resource> files = new ArrayList<Resource>();
        for (File f : File.listRoots()) {
            files.add(new FileResource(f));
        }
        return files;
    }

    @Override
    public List<Resource> resolve(Resource cwd) {
        ArrayList<Resource> files = new ArrayList<Resource>();
        for (File f : PathResolver.resolvePath(this.getFile(), ((FileResource)cwd).getFile())) {
            files.add(new FileResource(f));
        }
        return files;
    }

    @Override
    public InputStream read() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Class<A> type, LinkOption ... options) throws IOException {
        return Files.readAttributes(this.file.toPath(), type, options);
    }

    @Override
    public OutputStream write(boolean append) throws FileNotFoundException {
        return new FileOutputStream(this.file, append);
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public Resource newInstance(String path) {
        return new FileResource(path);
    }

    @Override
    public Resource copy(Resource destination) throws IOException {
        return new FileResource(Files.copy(this.file.toPath(), new FileResource(destination.getAbsolutePath()).getFile().toPath(), new CopyOption[0]).toFile());
    }

    @Override
    public boolean setLastModified(long time) {
        return this.file.setLastModified(time);
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public void setLastAccessed(long time) throws IOException {
        FileTime fileTime = FileTime.fromMillis(time);
        Files.setAttribute(this.file.toPath(), "lastAccessTime", fileTime, new LinkOption[0]);
    }

    @Override
    public long lastAccessed() throws IOException {
        BasicFileAttributes bfa = Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        FileTime lastAccessed = bfa.lastAccessTime();
        return lastAccessed.toMillis();
    }

    public File getFile() {
        return this.file;
    }
}

