/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigItemContainerBuilder;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupBuilderSupport;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PackageDepsSpecXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class FeatureGroupXml {
    private static final FeatureGroupXml INSTANCE = new FeatureGroupXml();
    public static final String NAMESPACE_1_0 = "urn:jboss:galleon:feature-group:1.0";

    public static FeatureGroupXml getInstance() {
        return INSTANCE;
    }

    public static void readFeatureGroupSpec(XMLExtendedStreamReader reader, FeatureGroup.Builder groupBuilder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        groupBuilder.setName(name);
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case FEATURE_GROUP: {
                            groupBuilder.addFeatureGroup(FeatureGroupXml.readFeatureGroupDependency(null, reader));
                            continue block14;
                        }
                        case ORIGIN: {
                            FeatureGroupXml.readOrigin(reader, groupBuilder);
                            continue block14;
                        }
                        case FEATURE: {
                            FeatureConfig nested = new FeatureConfig();
                            FeatureGroupXml.readFeatureConfig(reader, nested);
                            groupBuilder.addFeature(nested);
                            continue block14;
                        }
                        case PACKAGES: {
                            PackageDepsSpecXmlParser.parsePackageDeps(Element.PACKAGES, reader, groupBuilder);
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    public static void readOrigin(XMLExtendedStreamReader reader, ConfigItemContainerBuilder<?> groupBuilder) throws XMLStreamException {
        String origin = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    origin = reader.getAttributeValue(i);
                    continue block11;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (origin == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case FEATURE_GROUP: {
                            groupBuilder.addFeatureGroup(FeatureGroupXml.readFeatureGroupDependency(origin, reader));
                            continue block12;
                        }
                        case FEATURE: {
                            FeatureConfig nested = new FeatureConfig().setOrigin(origin);
                            FeatureGroupXml.readFeatureConfig(reader, nested);
                            groupBuilder.addFeature(nested);
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static FeatureGroup readFeatureGroupDependency(String origin, XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        Boolean inheritFeatures = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                case INHERIT_FEATURES: {
                    inheritFeatures = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block6;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null && inheritFeatures != null) {
            throw new XMLStreamException(Attribute.INHERIT_FEATURES + " attribute can't be used w/o attribute " + Attribute.NAME);
        }
        FeatureGroup.Builder depBuilder = (FeatureGroup.Builder)FeatureGroup.builder(name).setOrigin(origin);
        if (inheritFeatures != null) {
            depBuilder.setInheritFeatures(inheritFeatures);
        }
        FeatureGroupXml.readFeatureGroupConfigBody(reader, depBuilder);
        try {
            return depBuilder.build();
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse feature group dependency", reader.getLocation(), e);
        }
    }

    public static void readFeatureGroupConfigBody(XMLExtendedStreamReader reader, FeatureGroupBuilderSupport<?> builder) throws XMLStreamException {
        block4: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    if (FeatureGroupXml.handleFeatureGroupBodyElement(reader, builder)) continue block4;
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    public static boolean handleFeatureGroupBodyElement(XMLExtendedStreamReader reader, FeatureGroupBuilderSupport<?> builder) throws XMLStreamException {
        Element element = Element.of(reader.getName().getLocalPart());
        switch (element) {
            case INCLUDE: {
                FeatureGroupXml.readInclude(reader, null, builder);
                break;
            }
            case EXCLUDE: {
                FeatureGroupXml.readExclude(reader, null, builder);
                break;
            }
            case ORIGIN: {
                FeatureGroupXml.readOriginIncludeExclude(reader, builder);
                break;
            }
            case FEATURE_GROUP: {
                builder.addFeatureGroup(FeatureGroupXml.readFeatureGroupDependency(null, reader));
                break;
            }
            case FEATURE: {
                FeatureConfig nested = new FeatureConfig();
                FeatureGroupXml.readFeatureConfig(reader, nested);
                builder.addFeature(nested);
                break;
            }
            case PACKAGES: {
                PackageDepsSpecXmlParser.parsePackageDeps(Element.PACKAGES, reader, builder);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static void readOriginIncludeExclude(XMLExtendedStreamReader reader, FeatureGroupBuilderSupport<?> builder) throws XMLStreamException {
        String origin = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    origin = reader.getAttributeValue(i);
                    continue block14;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (origin == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case INCLUDE: {
                            FeatureGroupXml.readInclude(reader, origin, builder);
                            continue block15;
                        }
                        case EXCLUDE: {
                            FeatureGroupXml.readExclude(reader, origin, builder);
                            continue block15;
                        }
                        case FEATURE_GROUP: {
                            builder.addFeatureGroup(FeatureGroupXml.readFeatureGroupDependency(origin, reader));
                            continue block15;
                        }
                        case FEATURE: {
                            FeatureConfig nested = new FeatureConfig();
                            nested.setOrigin(origin);
                            FeatureGroupXml.readFeatureConfig(reader, nested);
                            builder.addFeature(nested);
                            continue block15;
                        }
                        case PACKAGES: {
                            PackageDepsSpecXmlParser.parsePackageDeps(Element.PACKAGES, reader, builder);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readInclude(XMLExtendedStreamReader reader, String origin, FeatureGroupBuilderSupport<?> depBuilder) throws XMLStreamException {
        String spec = null;
        String featureIdStr = null;
        String parentRef = null;
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case FEATURE_ID: {
                    featureIdStr = reader.getAttributeValue(i);
                    continue block20;
                }
                case SPEC: {
                    spec = reader.getAttributeValue(i);
                    continue block20;
                }
                case PARENT_REF: {
                    parentRef = reader.getAttributeValue(i);
                    continue block20;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (spec != null) {
            if (featureIdStr != null) {
                FeatureGroupXml.attributesCantBeCombined(Attribute.SPEC, Attribute.FEATURE_ID, reader);
            }
            if (parentRef != null) {
                FeatureGroupXml.attributesCantBeCombined(Attribute.SPEC, Attribute.PARENT_REF, reader);
            }
            try {
                depBuilder.includeSpec(origin, spec);
            }
            catch (ProvisioningDescriptionException e) {
                throw new XMLStreamException("Failed to parse config", e);
            }
            ParsingUtils.parseNoContent(reader);
            return;
        }
        if (featureIdStr == null) {
            throw new XMLStreamException("Either " + Attribute.SPEC + " or " + Attribute.FEATURE_ID + " has to be present", reader.getLocation());
        }
        FeatureId featureId = FeatureGroupXml.parseFeatureId(featureIdStr);
        FeatureConfig fc = new FeatureConfig();
        fc.setOrigin(origin);
        fc.setParentRef(parentRef);
        block21: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        depBuilder.includeFeature(featureId, fc);
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to parse config", e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case DEPENDS: {
                            FeatureGroupXml.readFeatureDependency(reader, fc);
                            continue block21;
                        }
                        case PARAM: {
                            FeatureGroupXml.readParameter(reader, fc);
                            continue block21;
                        }
                        case FEATURE: {
                            FeatureConfig nested = new FeatureConfig();
                            FeatureGroupXml.readFeatureConfig(reader, nested);
                            fc.addFeature(nested);
                            continue block21;
                        }
                        case RESET_PARAM: {
                            fc.resetParam(FeatureGroupXml.readParamAttr(reader));
                            continue block21;
                        }
                        case UNSET_PARAM: {
                            fc.unsetParam(FeatureGroupXml.readParamAttr(reader));
                            continue block21;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readExclude(XMLExtendedStreamReader reader, String dependency, FeatureGroupBuilderSupport<?> depBuilder) throws XMLStreamException {
        String spec = null;
        String featureIdStr = null;
        String parentRef = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case FEATURE_ID: {
                    featureIdStr = reader.getAttributeValue(i);
                    continue block9;
                }
                case SPEC: {
                    spec = reader.getAttributeValue(i);
                    continue block9;
                }
                case PARENT_REF: {
                    parentRef = reader.getAttributeValue(i);
                    continue block9;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (spec != null) {
            if (featureIdStr != null) {
                FeatureGroupXml.attributesCantBeCombined(Attribute.SPEC, Attribute.FEATURE_ID, reader);
            }
            if (parentRef != null) {
                FeatureGroupXml.attributesCantBeCombined(Attribute.SPEC, Attribute.PARENT_REF, reader);
            }
            try {
                depBuilder.excludeSpec(dependency, spec);
            }
            catch (ProvisioningDescriptionException e) {
                throw new XMLStreamException("Failed to parse config", e);
            }
        } else if (featureIdStr != null) {
            try {
                depBuilder.excludeFeature(dependency, FeatureGroupXml.parseFeatureId(featureIdStr), parentRef);
            }
            catch (ProvisioningDescriptionException e) {
                throw new XMLStreamException("Failed to parse config", e);
            }
        } else {
            throw new XMLStreamException("Either " + Attribute.SPEC + " or " + Attribute.FEATURE_ID + " has to be present", reader.getLocation());
        }
        ParsingUtils.parseNoContent(reader);
    }

    private static void attributesCantBeCombined(Attribute a1, Attribute a2, XMLExtendedStreamReader reader) throws XMLStreamException {
        throw new XMLStreamException(a1 + " attribute and " + a1 + " cannot be used in combination", reader.getLocation());
    }

    public static void readFeatureConfig(XMLExtendedStreamReader reader, FeatureConfig config) throws XMLStreamException {
        block19: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case SPEC: {
                    try {
                        config.setSpecName(reader.getAttributeValue(i));
                        continue block19;
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to parse config", e);
                    }
                }
                case PARENT_REF: {
                    config.setParentRef(reader.getAttributeValue(i));
                    continue block19;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (config.getSpecId() == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.SPEC));
        }
        block20: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case DEPENDS: {
                            FeatureGroupXml.readFeatureDependency(reader, config);
                            continue block20;
                        }
                        case PARAM: {
                            FeatureGroupXml.readParameter(reader, config);
                            continue block20;
                        }
                        case FEATURE: {
                            FeatureConfig child = new FeatureConfig();
                            FeatureGroupXml.readFeatureConfig(reader, child);
                            config.addFeature(child);
                            continue block20;
                        }
                        case FEATURE_GROUP: {
                            config.addFeatureGroup(FeatureGroupXml.readFeatureGroupDependency(null, reader));
                            continue block20;
                        }
                        case ORIGIN: {
                            FeatureGroupXml.readOrigin(reader, config);
                            continue block20;
                        }
                        case RESET_PARAM: {
                            config.resetParam(FeatureGroupXml.readParamAttr(reader));
                            continue block20;
                        }
                        case UNSET_PARAM: {
                            config.unsetParam(FeatureGroupXml.readParamAttr(reader));
                            continue block20;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readFeatureDependency(XMLExtendedStreamReader reader, FeatureConfig config) throws XMLStreamException {
        String id = null;
        String origin = null;
        boolean include = false;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case FEATURE_ID: {
                    id = reader.getAttributeValue(i);
                    continue block7;
                }
                case ORIGIN: {
                    origin = reader.getAttributeValue(i);
                    continue block7;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (id == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.FEATURE_ID));
        }
        ParsingUtils.parseNoContent(reader);
        try {
            config.addFeatureDep(FeatureDependencySpec.create(FeatureGroupXml.parseFeatureId(id), origin, include));
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException(e);
        }
    }

    private static FeatureId parseFeatureId(String id) throws XMLStreamException {
        try {
            return FeatureId.fromString(id);
        }
        catch (ProvisioningDescriptionException e) {
            throw new XMLStreamException("Failed to parse feature-id", e);
        }
    }

    private static void readParameter(XMLExtendedStreamReader reader, FeatureConfig config) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            Set<Attribute> missingAttrs;
            if (value == null) {
                missingAttrs = new HashSet<Attribute>();
                missingAttrs.add(Attribute.NAME);
                missingAttrs.add(Attribute.VALUE);
            } else {
                missingAttrs = Collections.singleton(Attribute.NAME);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), missingAttrs);
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        ParsingUtils.parseNoContent(reader);
        config.setParam(name, value);
    }

    private static String readParamAttr(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case PARAM: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.PARAM));
        }
        ParsingUtils.parseNoContent(reader);
        return name;
    }

    protected static enum Attribute implements XmlNameProvider
    {
        FEATURE("feature"),
        FEATURE_ID("feature-id"),
        INCLUDE("include"),
        INHERIT_FEATURES("inherit-features"),
        MODEL("model"),
        NAME("name"),
        OPTIONAL("optional"),
        ORIGIN("origin"),
        PARAM("param"),
        PARENT_REF("parent-ref"),
        SPEC("spec"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(13);
            attributes.put(new QName(Attribute.FEATURE.name), FEATURE);
            attributes.put(new QName(Attribute.FEATURE_ID.name), FEATURE_ID);
            attributes.put(new QName(Attribute.INCLUDE.name), INCLUDE);
            attributes.put(new QName(Attribute.INHERIT_FEATURES.name), INHERIT_FEATURES);
            attributes.put(new QName(Attribute.MODEL.name), MODEL);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.OPTIONAL.name), OPTIONAL);
            attributes.put(new QName(Attribute.ORIGIN.name), ORIGIN);
            attributes.put(new QName(Attribute.PARAM.name), PARAM);
            attributes.put(new QName(Attribute.PARENT_REF.name), PARENT_REF);
            attributes.put(new QName(Attribute.SPEC.name), SPEC);
            attributes.put(new QName(Attribute.VALUE.name), VALUE);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        DEPENDS("depends"),
        EXCLUDE("exclude"),
        FEATURE("feature"),
        FEATURE_GROUP("feature-group"),
        FEATURE_GROUP_SPEC("feature-group-spec"),
        INCLUDE("include"),
        ORIGIN("origin"),
        PACKAGES("packages"),
        PARAM("param"),
        RESET_PARAM("reset"),
        UNSET_PARAM("unset"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:feature-group:1.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return FeatureGroupXml.NAMESPACE_1_0;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(12);
            elementsByLocal.put(Element.DEPENDS.name, DEPENDS);
            elementsByLocal.put(Element.EXCLUDE.name, EXCLUDE);
            elementsByLocal.put(Element.FEATURE.name, FEATURE);
            elementsByLocal.put(Element.FEATURE_GROUP.name, FEATURE_GROUP);
            elementsByLocal.put(Element.FEATURE_GROUP_SPEC.name, FEATURE_GROUP_SPEC);
            elementsByLocal.put(Element.INCLUDE.name, INCLUDE);
            elementsByLocal.put(Element.ORIGIN.name, ORIGIN);
            elementsByLocal.put(Element.PACKAGES.name, PACKAGES);
            elementsByLocal.put(Element.PARAM.name, PARAM);
            elementsByLocal.put(Element.RESET_PARAM.name, RESET_PARAM);
            elementsByLocal.put(Element.UNSET_PARAM.name, UNSET_PARAM);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

