/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.Describable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaCompiler;
import org.gradle.jvm.toolchain.internal.DefaultToolchainJavaLauncher;
import org.gradle.jvm.toolchain.internal.JavaCompilerFactory;
import org.gradle.jvm.toolchain.internal.JavaInstallationProbe;
import org.gradle.jvm.toolchain.internal.ToolchainToolFactory;
import org.gradle.util.VersionNumber;

public class JavaToolchain
implements Describable,
JavaInstallationMetadata {
    private final boolean isJdk;
    private final JavaCompilerFactory compilerFactory;
    private final ToolchainToolFactory toolFactory;
    private final Directory javaHome;
    private final VersionNumber implementationVersion;
    private final JavaLanguageVersion javaVersion;

    @Inject
    public JavaToolchain(JavaInstallationProbe.ProbeResult probe, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, FileFactory fileFactory) {
        this(probe.getJavaHome(), JavaLanguageVersion.of(Integer.parseInt(probe.getJavaVersion().getMajorVersion())), probe.getImplementationJavaVersion(), probe.getInstallType() == JavaInstallationProbe.InstallType.IS_JDK, compilerFactory, toolFactory, fileFactory);
    }

    JavaToolchain(Path javaHome, JavaLanguageVersion version, String implementationJavaVersion, boolean isJdk, JavaCompilerFactory compilerFactory, ToolchainToolFactory toolFactory, FileFactory fileFactory) {
        this.javaHome = fileFactory.dir(this.computeEnclosingJavaHome(javaHome).toFile());
        this.javaVersion = version;
        this.isJdk = isJdk;
        this.compilerFactory = compilerFactory;
        this.toolFactory = toolFactory;
        this.implementationVersion = VersionNumber.parse((String)implementationJavaVersion);
    }

    @Internal
    public JavaCompiler getJavaCompiler() {
        return new DefaultToolchainJavaCompiler(this, this.compilerFactory);
    }

    @Internal
    public JavaLauncher getJavaLauncher() {
        return new DefaultToolchainJavaLauncher(this);
    }

    @Internal
    public JavadocTool getJavadocTool() {
        return this.toolFactory.create(JavadocTool.class, this);
    }

    @Override
    @Input
    public JavaLanguageVersion getLanguageVersion() {
        return this.javaVersion;
    }

    @Internal
    public VersionNumber getToolVersion() {
        return this.implementationVersion;
    }

    @Override
    @Internal
    public Directory getInstallationPath() {
        return this.javaHome;
    }

    @Internal
    public boolean isJdk() {
        return this.isJdk;
    }

    @Internal
    public String getDisplayName() {
        return this.javaHome.toString();
    }

    public RegularFile findExecutable(String toolname) {
        return this.getInstallationPath().file(this.getBinaryPath(toolname));
    }

    private Path computeEnclosingJavaHome(Path home) {
        Path parentPath = home.getParent();
        boolean isEmbeddedJre = home.getFileName().toString().equalsIgnoreCase("jre");
        if (isEmbeddedJre && parentPath.resolve(this.getBinaryPath("java")).toFile().exists()) {
            return parentPath;
        }
        return home;
    }

    private String getBinaryPath(String java) {
        return "bin/" + OperatingSystem.current().getExecutableName(java);
    }
}

