/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.util.HeaderToken;
import io.undertow.util.HeaderTokenParser;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public enum AuthenticationInfoToken implements HeaderToken
{
    NEXT_NONCE("nextnonce", true),
    MESSAGE_QOP("qop", true),
    RESPONSE_AUTH("rspauth", true),
    CNONCE("cnonce", true),
    NONCE_COUNT("nc", false);

    private static final HeaderTokenParser<AuthenticationInfoToken> TOKEN_PARSER;
    private final String name;
    private final boolean quoted;

    private AuthenticationInfoToken(String name, boolean quoted) {
        this.name = name;
        this.quoted = quoted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAllowQuoted() {
        return this.quoted;
    }

    public static Map<AuthenticationInfoToken, String> parseHeader(String header) {
        return TOKEN_PARSER.parseHeader(header);
    }

    static {
        LinkedHashMap<String, AuthenticationInfoToken> expected = new LinkedHashMap<String, AuthenticationInfoToken>(AuthenticationInfoToken.values().length);
        for (AuthenticationInfoToken current : AuthenticationInfoToken.values()) {
            expected.put(current.getName(), current);
        }
        TOKEN_PARSER = new HeaderTokenParser(Collections.unmodifiableMap(expected));
    }
}

