/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.httpcore;

import io.undertow.httpcore.ClientAuth;
import io.undertow.httpcore.RenegotiationRequiredException;
import io.undertow.httpcore.SSLSessionInfo;
import java.io.IOException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;

public class ConnectionSSLSessionInfo
implements SSLSessionInfo {
    private static final SSLPeerUnverifiedException PEER_UNVERIFIED_EXCEPTION = new SSLPeerUnverifiedException("");
    private static final RenegotiationRequiredException RENEGOTIATION_REQUIRED_EXCEPTION = new RenegotiationRequiredException();
    private static final long MAX_RENEGOTIATION_WAIT = 30000L;
    private final SSLSession session;
    private SSLPeerUnverifiedException unverified;
    private RenegotiationRequiredException renegotiationRequiredException;

    public ConnectionSSLSessionInfo(SSLSession session) {
        this.session = session;
    }

    @Override
    public byte[] getSessionId() {
        return this.session.getId();
    }

    @Override
    public String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        if (this.unverified != null) {
            throw this.unverified;
        }
        if (this.renegotiationRequiredException != null) {
            throw this.renegotiationRequiredException;
        }
        try {
            return this.session.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException e) {
            this.unverified = PEER_UNVERIFIED_EXCEPTION;
            throw this.unverified;
        }
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException, RenegotiationRequiredException {
        if (this.unverified != null) {
            throw this.unverified;
        }
        if (this.renegotiationRequiredException != null) {
            throw this.renegotiationRequiredException;
        }
        try {
            return this.session.getPeerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            this.unverified = PEER_UNVERIFIED_EXCEPTION;
            throw this.unverified;
        }
    }

    @Override
    public void renegotiate(ClientAuth sslClientAuthMode) throws IOException {
    }

    @Override
    public SSLSession getSSLSession() {
        return this.session;
    }
}

