/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.Arrays;
import java.util.List;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class SecurityOptions {
    public static final Option<FipsMode> FIPS_MODE = new OptionBuilder<FipsMode>("fips-mode", FipsMode.class).category(OptionCategory.SECURITY).expectedValues(SecurityOptions::getFipsModeValues).buildTime(true).description("Sets the FIPS mode. If '" + FipsMode.NON_STRICT + "' is set, FIPS is enabled but on non-approved mode. For full FIPS compliance, set '" + FipsMode.STRICT + "' to run on approved mode.").defaultValue(FipsMode.DISABLED).build();

    private static List<String> getFipsModeValues() {
        return Arrays.asList(FipsMode.NON_STRICT.toString(), FipsMode.STRICT.toString());
    }
}

