/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.jboss.logmanager.Level;

public class LogMetricsHandler
extends Handler {
    final NavigableMap<Integer, LongAdder> logCounters;

    public LogMetricsHandler(NavigableMap<Integer, LongAdder> logCounters) {
        this.logCounters = logCounters;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            Map.Entry<Integer, LongAdder> counter = this.logCounters.floorEntry(record.getLevel().intValue());
            if (counter != null) {
                counter.getValue().increment();
            } else {
                ((LongAdder)this.logCounters.get(Level.TRACE.intValue())).increment();
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

