/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapAuthenticationExecutionEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapAuthenticationExecutionEntity fromModel(AuthenticationExecutionModel model) {
        if (model == null) {
            return null;
        }
        MapAuthenticationExecutionEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapAuthenticationExecutionEntity.class);
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setAuthenticator(model.getAuthenticator());
        entity.setAuthenticatorConfig(model.getAuthenticatorConfig());
        entity.setFlowId(model.getFlowId());
        entity.setParentFlowId(model.getParentFlow());
        entity.setRequirement(model.getRequirement());
        entity.setAutheticatorFlow(model.isAuthenticatorFlow());
        entity.setPriority(model.getPriority());
        return entity;
    }

    public static AuthenticationExecutionModel toModel(MapAuthenticationExecutionEntity entity) {
        if (entity == null) {
            return null;
        }
        AuthenticationExecutionModel model = new AuthenticationExecutionModel();
        model.setId(entity.getId());
        model.setAuthenticator(entity.getAuthenticator());
        model.setAuthenticatorConfig(entity.getAuthenticatorConfig());
        model.setFlowId(entity.getFlowId());
        model.setParentFlow(entity.getParentFlowId());
        model.setRequirement(entity.getRequirement());
        Boolean authenticatorFlow = entity.isAutheticatorFlow();
        model.setAuthenticatorFlow(authenticatorFlow == null ? false : authenticatorFlow);
        Integer priority = entity.getPriority();
        model.setPriority(priority == null ? 0 : priority);
        return model;
    }

    public String getAuthenticator();

    public void setAuthenticator(String var1);

    public String getAuthenticatorConfig();

    public void setAuthenticatorConfig(String var1);

    public AuthenticationExecutionModel.Requirement getRequirement();

    public void setRequirement(AuthenticationExecutionModel.Requirement var1);

    public Boolean isAutheticatorFlow();

    public void setAutheticatorFlow(Boolean var1);

    public String getFlowId();

    public void setFlowId(String var1);

    public String getParentFlowId();

    public void setParentFlowId(String var1);

    public Integer getPriority();

    public void setPriority(Integer var1);
}

