/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.LogContainerCmd;
import java.io.Closeable;
import java.util.function.Consumer;
import org.testcontainers.containers.output.FrameConsumerResultCallback;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.containers.output.WaitingConsumer;

public final class LogUtils {
    public static void followOutput(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer, OutputFrame.OutputType ... types) {
        LogUtils.attachConsumer(dockerClient, containerId, consumer, true, types);
    }

    public static void followOutput(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer) {
        LogUtils.followOutput(dockerClient, containerId, consumer, OutputFrame.OutputType.STDOUT, OutputFrame.OutputType.STDERR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getOutput(DockerClient dockerClient, String containerId, OutputFrame.OutputType ... types) {
        if (containerId == null) {
            return "";
        }
        if (types.length == 0) {
            types = new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT, OutputFrame.OutputType.STDERR};
        }
        ToStringConsumer consumer = new ToStringConsumer();
        WaitingConsumer wait = new WaitingConsumer();
        try (Closeable closeable = LogUtils.attachConsumer(dockerClient, containerId, consumer.andThen(wait), false, types);){
            wait.waitUntilEnd();
            String string = consumer.toUtf8String();
            return string;
        }
    }

    private static Closeable attachConsumer(DockerClient dockerClient, String containerId, Consumer<OutputFrame> consumer, boolean followStream, OutputFrame.OutputType ... types) {
        LogContainerCmd cmd = dockerClient.logContainerCmd(containerId).withFollowStream(Boolean.valueOf(followStream)).withSince(Integer.valueOf(0));
        FrameConsumerResultCallback callback = new FrameConsumerResultCallback();
        for (OutputFrame.OutputType type : types) {
            callback.addConsumer(type, consumer);
            if (type == OutputFrame.OutputType.STDOUT) {
                cmd.withStdOut(Boolean.valueOf(true));
            }
            if (type != OutputFrame.OutputType.STDERR) continue;
            cmd.withStdErr(Boolean.valueOf(true));
        }
        return cmd.exec((ResultCallback)callback);
    }

    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

