/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.handlers.ByteStringBuilder;
import org.jboss.logmanager.handlers.ClientSocketFactory;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.jboss.logmanager.handlers.UdpOutputStream;
import org.wildfly.common.os.Process;

public class SyslogHandler
extends ExtHandler {
    public static final InetAddress DEFAULT_ADDRESS;
    public static final int DEFAULT_PORT = 514;
    public static final int DEFAULT_SECURE_PORT = 6514;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Facility DEFAULT_FACILITY;
    public static final String NILVALUE_SP = "- ";
    private static final Pattern PRINTABLE_ASCII_PATTERN;
    private final Object outputLock = new Object();
    private InetAddress serverAddress;
    private int port;
    private String appName;
    private String hostname;
    private Facility facility;
    private SyslogType syslogType;
    private final String pid;
    private OutputStream out;
    private Protocol protocol;
    private boolean useCountingFraming;
    private boolean initializeConnection;
    private boolean outputStreamSet;
    private String delimiter;
    private boolean useDelimiter;
    private boolean truncate;
    private int maxLen;
    private boolean blockOnReconnect;
    private ClientSocketFactory clientSocketFactory;

    public SyslogHandler() throws IOException {
        this(DEFAULT_ADDRESS, 514);
    }

    public SyslogHandler(String serverHostname, int port) throws IOException {
        this(serverHostname, port, DEFAULT_FACILITY, null);
    }

    public SyslogHandler(InetAddress serverAddress, int port) throws IOException {
        this(serverAddress, port, DEFAULT_FACILITY, null);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, String hostname) throws IOException {
        this(serverHostname, port, facility, null, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, String hostname) throws IOException {
        this(serverAddress, port, facility, null, hostname);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, SyslogType syslogType, String hostname) throws IOException {
        this(InetAddress.getByName(serverHostname), port, facility, syslogType, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, SyslogType syslogType, String hostname) throws IOException {
        this(serverAddress, port, facility, syslogType, null, hostname);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, SyslogType syslogType, Protocol protocol, String hostname) throws IOException {
        this(InetAddress.getByName(serverHostname), port, facility, syslogType, protocol, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, SyslogType syslogType, Protocol protocol, String hostname) throws IOException {
        this.serverAddress = serverAddress;
        this.port = port;
        this.facility = facility;
        long pid = Process.getProcessId();
        this.pid = pid != -1L ? Long.toString(pid) : null;
        this.appName = "java";
        this.hostname = SyslogHandler.checkPrintableAscii("host name", hostname);
        SyslogType syslogType2 = this.syslogType = syslogType == null ? SyslogType.RFC5424 : syslogType;
        if (protocol == null) {
            this.protocol = Protocol.UDP;
            this.delimiter = null;
            this.useDelimiter = false;
        } else {
            this.protocol = protocol;
            if (protocol == Protocol.UDP) {
                this.delimiter = null;
                this.useDelimiter = false;
            } else if (protocol == Protocol.TCP || protocol == Protocol.SSL_TCP) {
                this.delimiter = "\n";
                this.useDelimiter = true;
            }
        }
        this.useCountingFraming = false;
        this.initializeConnection = true;
        this.outputStreamSet = false;
        this.truncate = true;
        if (this.syslogType == SyslogType.RFC3164) {
            this.maxLen = 1024;
        } else if (this.syslogType == SyslogType.RFC5424) {
            this.maxLen = 2048;
        }
        this.blockOnReconnect = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.init();
            if (this.out == null) {
                throw new IllegalStateException("The syslog handler has been closed.");
            }
            try {
                byte[] byArray;
                byte[] header;
                if (this.syslogType == SyslogType.RFC3164) {
                    header = this.createRFC3164Header(record);
                } else if (this.syslogType == SyslogType.RFC5424) {
                    header = this.createRFC5424Header(record);
                } else {
                    throw new IllegalStateException("The syslog type of '" + (Object)((Object)this.syslogType) + "' is invalid.");
                }
                if (this.delimiter == null) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 0;
                } else {
                    byArray = this.delimiter.getBytes(DEFAULT_ENCODING);
                }
                byte[] trailer = byArray;
                int maxMsgLen = this.maxLen - (header.length + (this.useDelimiter ? trailer.length : 0));
                if (maxMsgLen < 1) {
                    throw new IOException(String.format("The header and delimiter length, %d, is greater than the message length, %d, allows.", header.length + (this.useDelimiter ? trailer.length : 0), this.maxLen));
                }
                Formatter formatter = this.getFormatter();
                String logMsg = formatter != null ? formatter.format(record) : record.getFormattedMessage();
                if (!Normalizer.isNormalized(logMsg, Normalizer.Form.NFKC)) {
                    logMsg = Normalizer.normalize(logMsg, Normalizer.Form.NFKC);
                }
                ByteStringBuilder message = new ByteStringBuilder(maxMsgLen);
                int len = message.write(logMsg, maxMsgLen);
                this.sendMessage(header, message, trailer);
                if (!this.truncate && len < logMsg.length()) {
                    while (len > 0 && !(logMsg = logMsg.substring(len + 1)).isEmpty()) {
                        message = new ByteStringBuilder(maxMsgLen);
                        len = message.write(logMsg, maxMsgLen);
                        this.sendMessage(header, message, trailer);
                    }
                }
            }
            catch (IOException e) {
                this.reportError("Could not write to syslog", e, 1);
            }
        }
        super.doPublish(record);
    }

    private void sendMessage(byte[] header, ByteStringBuilder message, byte[] trailer) throws IOException {
        ByteStringBuilder payload = new ByteStringBuilder(header.length + message.length());
        if (this.useCountingFraming) {
            int len = header.length + message.length() + (this.useDelimiter ? trailer.length : 0);
            payload.append(len).append(' ');
        }
        payload.append(header);
        payload.append(message);
        if (this.useDelimiter) {
            payload.append(trailer);
        }
        this.out.write(payload.toArray());
        if (this.out instanceof TcpOutputStream) {
            Collection<Exception> errors = ((TcpOutputStream)this.out).getErrors();
            for (Exception error : errors) {
                this.reportError("Error writing to TCP stream", error, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.outputLock;
        synchronized (object) {
            SyslogHandler.safeClose(this.out);
            this.out = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.outputLock;
        synchronized (object) {
            SyslogHandler.safeFlush(this.out);
        }
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppName() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.appName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppName(String appName) {
        Object object = this.outputLock;
        synchronized (object) {
            this.appName = SyslogHandler.checkPrintableAscii("app name", appName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlockOnReconnect() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.blockOnReconnect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockOnReconnect(boolean blockOnReconnect) {
        Object object = this.outputLock;
        synchronized (object) {
            this.blockOnReconnect = blockOnReconnect;
            if (this.out instanceof TcpOutputStream) {
                ((TcpOutputStream)this.out).setBlockOnReconnect(blockOnReconnect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientSocketFactory(ClientSocketFactory clientSocketFactory) {
        Object object = this.outputLock;
        synchronized (object) {
            this.clientSocketFactory = clientSocketFactory;
            this.initializeConnection = true;
        }
    }

    @Deprecated
    public boolean isEscapeEnabled() {
        return false;
    }

    @Deprecated
    public void setEscapeEnabled(boolean escapeEnabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPid() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.pid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        Object object = this.outputLock;
        synchronized (object) {
            this.port = port;
            this.initializeConnection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Facility getFacility() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.facility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacility(Facility facility) {
        Object object = this.outputLock;
        synchronized (object) {
            this.facility = facility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostname() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.hostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxLength() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.maxLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxLength(int maxLen) {
        Object object = this.outputLock;
        synchronized (object) {
            this.maxLen = maxLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageDelimiter() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.delimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageDelimiter(String delimiter) {
        Object object = this.outputLock;
        synchronized (object) {
            this.delimiter = delimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseMessageDelimiter() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.useDelimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseMessageDelimiter(boolean useDelimiter) {
        Object object = this.outputLock;
        synchronized (object) {
            this.useDelimiter = useDelimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostname(String hostname) {
        Object object = this.outputLock;
        synchronized (object) {
            this.hostname = SyslogHandler.checkPrintableAscii("host name", hostname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseCountingFraming() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.useCountingFraming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseCountingFraming(boolean useCountingFraming) {
        Object object = this.outputLock;
        synchronized (object) {
            this.useCountingFraming = useCountingFraming;
        }
    }

    public void setServerHostname(String hostname) throws UnknownHostException {
        this.setServerAddress(InetAddress.getByName(hostname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getServerAddress() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.serverAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerAddress(InetAddress serverAddress) {
        Object object = this.outputLock;
        synchronized (object) {
            this.serverAddress = serverAddress;
            this.initializeConnection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyslogType getSyslogType() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.syslogType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyslogType(SyslogType syslogType) {
        Object object = this.outputLock;
        synchronized (object) {
            this.syslogType = syslogType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protocol getProtocol() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.protocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocol(Protocol type) {
        Object object = this.outputLock;
        synchronized (object) {
            this.protocol = type;
            this.initializeConnection = true;
        }
    }

    public void setOutputStream(OutputStream out) {
        this.setOutputStream(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTruncate() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.truncate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTruncate(boolean truncate) {
        Object object = this.outputLock;
        synchronized (object) {
            this.truncate = truncate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutputStream(OutputStream out, boolean outputStreamSet) {
        OutputStream oldOut = null;
        boolean ok = false;
        try {
            Object object = this.outputLock;
            synchronized (object) {
                this.initializeConnection = false;
                oldOut = this.out;
                if (oldOut != null) {
                    SyslogHandler.safeFlush(oldOut);
                }
                this.out = out;
                ok = true;
                this.outputStreamSet = out != null && outputStreamSet;
            }
        }
        catch (Throwable throwable) {
            SyslogHandler.safeClose(oldOut);
            if (!ok) {
                SyslogHandler.safeClose(out);
            }
            throw throwable;
        }
        SyslogHandler.safeClose(oldOut);
        if (!ok) {
            SyslogHandler.safeClose(out);
        }
    }

    static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void safeFlush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void init() {
        if (this.initializeConnection && !this.outputStreamSet) {
            if (this.serverAddress == null || this.port < 0 || this.protocol == null) {
                throw new IllegalStateException("Invalid connection parameters. The port, server address and protocol must be set.");
            }
            this.initializeConnection = false;
            try {
                ClientSocketFactory clientSocketFactory = this.getClientSocketFactory();
                OutputStream out = this.protocol == Protocol.UDP ? new UdpOutputStream(clientSocketFactory) : new TcpOutputStream(clientSocketFactory, this.blockOnReconnect);
                this.setOutputStream(out, false);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not set " + (Object)((Object)this.protocol) + " output stream.", e);
            }
        }
    }

    protected int calculatePriority(java.util.logging.Level level, Facility facility) {
        Severity severity = Severity.fromLevel(level);
        return facility.octal | severity.code;
    }

    protected byte[] createRFC5424Header(ExtLogRecord record) throws IOException {
        ByteStringBuilder buffer = new ByteStringBuilder(256);
        buffer.append('<').append(this.calculatePriority(record.getLevel(), this.facility)).append('>');
        buffer.appendUSASCII("1 ");
        long millis = record.getMillis();
        if (millis <= 0L) {
            buffer.appendUSASCII(NILVALUE_SP);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(millis);
            int month = cal.get(2);
            int day = cal.get(5);
            int hours = cal.get(11);
            int minutes = cal.get(12);
            int seconds = cal.get(13);
            buffer.append(cal.get(1)).append('-');
            if (month < 9) {
                buffer.append(0);
            }
            buffer.append(month + 1).append('-');
            if (day < 10) {
                buffer.append(0);
            }
            buffer.append(day).append('T');
            if (hours < 10) {
                buffer.append(0);
            }
            buffer.append(hours).append(':');
            if (minutes < 10) {
                buffer.append(0);
            }
            buffer.append(minutes).append(':');
            if (seconds < 10) {
                buffer.append(0);
            }
            buffer.append(seconds).append('.');
            int milliseconds = cal.get(14);
            if (milliseconds < 10) {
                buffer.append(0).append(0);
            } else if (milliseconds < 100) {
                buffer.append(0);
            }
            buffer.append(milliseconds);
            int tz = cal.get(15) + cal.get(16);
            if (tz == 0) {
                buffer.append("+00:00");
            } else {
                int tzMinutes = tz / 60000;
                if (tzMinutes < 0) {
                    tzMinutes = -tzMinutes;
                    buffer.append('-');
                } else {
                    buffer.append('+');
                }
                int tzHour = tzMinutes / 60;
                tzMinutes -= tzHour * 60;
                if (tzHour < 10) {
                    buffer.append(0);
                }
                buffer.append(tzHour).append(':');
                if (tzMinutes < 10) {
                    buffer.append(0);
                }
                buffer.append(tzMinutes);
            }
            buffer.append(' ');
        }
        String recordHostName = record.getHostName();
        if (this.hostname != null) {
            buffer.appendPrintUSASCII(this.hostname, 255).append(' ');
        } else if (recordHostName != null) {
            buffer.appendPrintUSASCII(recordHostName, 255).append(' ');
        } else {
            buffer.append(NILVALUE_SP);
        }
        String recordProcName = record.getProcessName();
        if (this.appName != null) {
            buffer.appendPrintUSASCII(this.appName, 48);
            buffer.append(' ');
        } else if (recordProcName != null) {
            buffer.appendPrintUSASCII(recordProcName, 48);
            buffer.append(' ');
        } else {
            buffer.appendUSASCII(NILVALUE_SP);
        }
        long recordProcId = record.getProcessId();
        if (recordProcId != -1L) {
            buffer.append(recordProcId);
            buffer.append(' ');
        } else if (this.pid != null) {
            buffer.appendPrintUSASCII(this.pid, 128);
            buffer.append(' ');
        } else {
            buffer.appendUSASCII(NILVALUE_SP);
        }
        String msgid = record.getLoggerName();
        if (msgid == null) {
            buffer.appendUSASCII(NILVALUE_SP);
        } else if (msgid.isEmpty()) {
            buffer.appendUSASCII("root-logger");
            buffer.append(' ');
        } else {
            buffer.appendPrintUSASCII(msgid, 32);
            buffer.append(' ');
        }
        buffer.appendUSASCII(NILVALUE_SP);
        String encoding = this.getEncoding();
        if (encoding == null || DEFAULT_ENCODING.equalsIgnoreCase(encoding)) {
            buffer.appendUtf8Raw(65279);
        }
        return buffer.toArray();
    }

    protected byte[] createRFC3164Header(ExtLogRecord record) throws IOException {
        ByteStringBuilder buffer = new ByteStringBuilder(256);
        buffer.append('<').append(this.calculatePriority(record.getLevel(), this.facility)).append('>');
        long millis = record.getMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis <= 0L ? System.currentTimeMillis() : millis);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        DateFormatSymbols formatSymbols = DateFormatSymbols.getInstance(Locale.ENGLISH);
        buffer.appendUSASCII(formatSymbols.getShortMonths()[month]).append(' ');
        if (day < 10) {
            buffer.append(' ');
        }
        buffer.append(day).append(' ');
        if (hours < 10) {
            buffer.append(0);
        }
        buffer.append(hours).append(':');
        if (minutes < 10) {
            buffer.append(0);
        }
        buffer.append(minutes).append(':');
        if (seconds < 10) {
            buffer.append(0);
        }
        buffer.append(seconds);
        buffer.append(' ');
        String recordHostName = record.getHostName();
        if (this.hostname != null) {
            buffer.appendUSASCII(this.hostname).append(' ');
        } else if (recordHostName != null) {
            buffer.appendUSASCII(recordHostName).append(' ');
        } else {
            buffer.appendUSASCII("UNKNOWN_HOSTNAME").append(' ');
        }
        String recordProcName = record.getProcessName();
        boolean colon = false;
        if (this.appName != null) {
            buffer.appendUSASCII(this.appName);
            colon = true;
        } else if (recordProcName != null) {
            buffer.appendUSASCII(recordProcName);
            colon = true;
        }
        long recordProcId = record.getProcessId();
        if (recordProcId != -1L) {
            buffer.append('[').append(recordProcId).append(']');
            colon = true;
        } else if (this.pid != null) {
            buffer.append('[').appendUSASCII(this.pid).append(']');
            colon = true;
        }
        if (colon) {
            buffer.append(':').append(' ');
        }
        return buffer.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSocketFactory getClientSocketFactory() {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.clientSocketFactory != null) {
                return this.clientSocketFactory;
            }
            SocketFactory socketFactory = this.protocol == Protocol.SSL_TCP ? SSLSocketFactory.getDefault() : SocketFactory.getDefault();
            return ClientSocketFactory.of(socketFactory, this.serverAddress, this.port);
        }
    }

    private static String checkPrintableAscii(String name, String value) {
        if (value != null && PRINTABLE_ASCII_PATTERN.matcher(value).find()) {
            String upper = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            throw new IllegalArgumentException(String.format("%s '%s' is invalid. The %s must be printable ASCII characters with no spaces.", upper, value, name));
        }
        return value;
    }

    static {
        DEFAULT_FACILITY = Facility.USER_LEVEL;
        PRINTABLE_ASCII_PATTERN = Pattern.compile("[\\P{Print} ]");
        try {
            DEFAULT_ADDRESS = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not create address to localhost");
        }
    }

    public static enum Facility {
        KERNEL(0, "kernel messages"),
        USER_LEVEL(1, "user-level messages"),
        MAIL_SYSTEM(2, "mail system"),
        SYSTEM_DAEMONS(3, "system daemons"),
        SECURITY(4, "security/authorization messages"),
        SYSLOGD(5, "messages generated internally by syslogd"),
        LINE_PRINTER(6, "line printer subsystem"),
        NETWORK_NEWS(7, "network news subsystem"),
        UUCP(8, "UUCP subsystem"),
        CLOCK_DAEMON(9, "clock daemon"),
        SECURITY2(10, "security/authorization messages"),
        FTP_DAEMON(11, "FTP daemon"),
        NTP(12, "NTP subsystem"),
        LOG_AUDIT(13, "log audit"),
        LOG_ALERT(14, "log alert"),
        CLOCK_DAEMON2(15, "clock daemon (note 2)"),
        LOCAL_USE_0(16, "local use 0  (local0)"),
        LOCAL_USE_1(17, "local use 1  (local1)"),
        LOCAL_USE_2(18, "local use 2  (local2)"),
        LOCAL_USE_3(19, "local use 3  (local3)"),
        LOCAL_USE_4(20, "local use 4  (local4)"),
        LOCAL_USE_5(21, "local use 5  (local5)"),
        LOCAL_USE_6(22, "local use 6  (local6)"),
        LOCAL_USE_7(23, "local use 7  (local7)");

        final int code;
        final String desc;
        final int octal;

        private Facility(int code, String desc) {
            this.code = code;
            this.desc = desc;
            this.octal = code * 8;
        }

        public String toString() {
            return String.format("%s[%d,%s]", this.name(), this.code, this.desc);
        }
    }

    public static enum SyslogType {
        RFC5424,
        RFC3164;

    }

    public static enum Protocol {
        TCP,
        UDP,
        SSL_TCP;

    }

    public static enum Severity {
        EMERGENCY(0, "Emergency: system is unusable"),
        ALERT(1, "Alert: action must be taken immediately"),
        CRITICAL(2, "Critical: critical conditions"),
        ERROR(3, "Error: error conditions"),
        WARNING(4, "Warning: warning conditions"),
        NOTICE(5, "Notice: normal but significant condition"),
        INFORMATIONAL(6, "Informational: informational messages"),
        DEBUG(7, "Debug: debug-level messages");

        final int code;
        final String desc;

        private Severity(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String toString() {
            return String.format("%s[%d,%s]", this.name(), this.code, this.desc);
        }

        public static Severity fromLevel(java.util.logging.Level level) {
            if (level == null) {
                throw new IllegalArgumentException("Level cannot be null");
            }
            int levelValue = level.intValue();
            if (levelValue >= Level.FATAL.intValue()) {
                return EMERGENCY;
            }
            if (levelValue >= Level.SEVERE.intValue() || levelValue >= Level.ERROR.intValue()) {
                return ERROR;
            }
            if (levelValue >= Level.WARN.intValue() || levelValue >= java.util.logging.Level.WARNING.intValue()) {
                return WARNING;
            }
            if (levelValue >= Level.INFO.intValue()) {
                return INFORMATIONAL;
            }
            if (levelValue >= Level.TRACE.intValue() || levelValue >= java.util.logging.Level.FINEST.intValue()) {
                return DEBUG;
            }
            return INFORMATIONAL;
        }
    }
}

