/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.Locale;

enum IPAddressPreference {
    IPv4First("IPv4First"),
    IPv6First("IPv6First"),
    UsePlatformDefault("UsePlatformDefault");

    private final String name;

    private IPAddressPreference(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    static IPAddressPreference valueOfString(String value) throws SQLServerException {
        IPAddressPreference iptype = null;
        if (value.toLowerCase(Locale.US).equalsIgnoreCase(IPv4First.toString())) {
            iptype = IPv4First;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(IPv6First.toString())) {
            iptype = IPv6First;
        } else if (value.toLowerCase(Locale.US).equalsIgnoreCase(UsePlatformDefault.toString())) {
            iptype = UsePlatformDefault;
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidIPAddressPreference"));
            Object[] msgArgs = new Object[]{value};
            throw new SQLServerException(form.format(msgArgs), null);
        }
        return iptype;
    }
}

