/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.multipart;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartMessageBodyWriter;
import org.jboss.resteasy.reactive.server.core.multipart.MultipartOutputInjectionTarget;
import org.jboss.resteasy.reactive.server.core.multipart.PartItem;
import org.jboss.resteasy.reactive.server.processor.util.JavaBeanUtil;

public final class FormDataOutputMapperGenerator {
    private static final Logger LOGGER = Logger.getLogger(FormDataOutputMapperGenerator.class);
    private static final String TRANSFORM_METHOD_NAME = "mapFrom";
    private static final String ADD_FORM_DATA_METHOD_NAME = "addFormData";

    private FormDataOutputMapperGenerator() {
    }

    public static boolean isReturnTypeCompatible(ClassInfo returnTypeClassInfo, IndexView index) {
        ClassInfo currentClassInHierarchy = returnTypeClassInfo;
        while (true) {
            List fields = currentClassInHierarchy.fields();
            for (FieldInfo field : fields) {
                if (Modifier.isStatic(field.flags()) || field.annotation(ResteasyReactiveDotNames.REST_FORM_PARAM) == null && field.annotation(ResteasyReactiveDotNames.FORM_PARAM) == null) continue;
                return true;
            }
            DotName superClassDotName = currentClassInHierarchy.superName();
            if (superClassDotName.equals((Object)ResteasyReactiveDotNames.OBJECT_NAME)) break;
            ClassInfo newCurrentClassInHierarchy = index.getClassByName(superClassDotName);
            if (newCurrentClassInHierarchy == null) {
                FormDataOutputMapperGenerator.printWarningMessageForMissingJandexIndex(currentClassInHierarchy, superClassDotName);
                break;
            }
            currentClassInHierarchy = newCurrentClassInHierarchy;
        }
        return false;
    }

    public static String generate(ClassInfo returnTypeClassInfo, ClassOutput classOutput, IndexView index) {
        String returnClassName = returnTypeClassInfo.name().toString();
        String generateClassName = MultipartMessageBodyWriter.getGeneratedMapperClassNameFor((String)returnClassName);
        String interfaceClassName = MultipartOutputInjectionTarget.class.getName();
        try (ClassCreator cc = new ClassCreator(classOutput, generateClassName, null, Object.class.getName(), new String[]{interfaceClassName});){
            MethodCreator populate = cc.getMethodCreator(TRANSFORM_METHOD_NAME, (Object)MultipartFormDataOutput.class.getName(), new Object[]{Object.class});
            populate.setModifiers(1);
            ResultHandle formDataInstanceHandle = populate.newInstance(MethodDescriptor.ofConstructor(MultipartFormDataOutput.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle inputInstanceHandle = populate.checkCast(populate.getMethodParam(0), returnClassName);
            ClassInfo currentClassInHierarchy = returnTypeClassInfo;
            while (true) {
                List fields = currentClassInHierarchy.fields();
                for (FieldInfo field : fields) {
                    List argumentTypes;
                    AnnotationValue partTypeValue;
                    if (Modifier.isStatic(field.flags())) continue;
                    AnnotationInstance formParamInstance = field.annotation(ResteasyReactiveDotNames.REST_FORM_PARAM);
                    if (formParamInstance == null) {
                        formParamInstance = field.annotation(ResteasyReactiveDotNames.FORM_PARAM);
                    }
                    if (formParamInstance == null) continue;
                    boolean useFieldAccess = false;
                    String getterName = JavaBeanUtil.getGetterName(field.name(), field.type().name());
                    Type fieldType = field.type();
                    DotName fieldDotName = fieldType.name();
                    MethodInfo getter = currentClassInHierarchy.method(getterName, new Type[0]);
                    if (getter == null) {
                        useFieldAccess = true;
                    }
                    if (!useFieldAccess && !Modifier.isPublic(getter.flags())) {
                        throw new IllegalArgumentException("Getter '" + getterName + "' of class '" + returnTypeClassInfo + "' must be public");
                    }
                    String formAttrName = field.name();
                    AnnotationValue formParamValue = formParamInstance.value();
                    if (formParamValue != null) {
                        formAttrName = formParamValue.asString();
                    }
                    String partType = "text/plain";
                    AnnotationInstance partTypeInstance = field.annotation(ResteasyReactiveDotNames.PART_TYPE_NAME);
                    if (partTypeInstance != null && (partTypeValue = partTypeInstance.value()) != null) {
                        partType = partTypeValue.asString();
                    }
                    AssignableResultHandle partTypeHandle = populate.createVariable(MediaType.class);
                    populate.assign(partTypeHandle, populate.invokeStaticMethod(MethodDescriptor.ofMethod(MediaType.class, (String)"valueOf", MediaType.class, (Class[])new Class[]{String.class}), new ResultHandle[]{populate.load(partType)}));
                    AssignableResultHandle resultHandle = populate.createVariable(Object.class);
                    if (useFieldAccess) {
                        populate.assign(resultHandle, populate.readInstanceField(FieldDescriptor.of((String)currentClassInHierarchy.name().toString(), (String)field.name(), (String)fieldDotName.toString()), inputInstanceHandle));
                    } else {
                        populate.assign(resultHandle, populate.invokeVirtualMethod(MethodDescriptor.ofMethod((String)currentClassInHierarchy.name().toString(), (String)getterName, (String)fieldDotName.toString(), (String[])new String[0]), inputInstanceHandle, new ResultHandle[0]));
                    }
                    String genericType = "";
                    if (fieldType.kind() == Type.Kind.PARAMETERIZED_TYPE && (argumentTypes = fieldType.asParameterizedType().arguments()).size() > 0) {
                        genericType = ((Type)argumentTypes.get(0)).name().toString();
                    }
                    populate.invokeVirtualMethod(MethodDescriptor.ofMethod(MultipartFormDataOutput.class, (String)ADD_FORM_DATA_METHOD_NAME, PartItem.class, (Class[])new Class[]{String.class, Object.class, String.class, MediaType.class}), formDataInstanceHandle, new ResultHandle[]{populate.load(formAttrName), resultHandle, populate.load(genericType), partTypeHandle});
                }
                DotName superClassDotName = currentClassInHierarchy.superName();
                if (superClassDotName.equals((Object)ResteasyReactiveDotNames.OBJECT_NAME)) break;
                ClassInfo newCurrentClassInHierarchy = index.getClassByName(superClassDotName);
                if (newCurrentClassInHierarchy == null) {
                    FormDataOutputMapperGenerator.printWarningMessageForMissingJandexIndex(currentClassInHierarchy, superClassDotName);
                    break;
                }
                currentClassInHierarchy = newCurrentClassInHierarchy;
            }
            populate.returnValue(formDataInstanceHandle);
        }
        return generateClassName;
    }

    private static void printWarningMessageForMissingJandexIndex(ClassInfo currentClassInHierarchy, DotName superClassDotName) {
        if (!superClassDotName.toString().startsWith("java.")) {
            LOGGER.warn((Object)("Class '" + superClassDotName + "' which is a parent class of '" + currentClassInHierarchy.name() + "' is not part of the Jandex index so its fields will be ignored. If you intended to include these fields, consider making the dependency part of the Jandex index by following the advice at: https://quarkus.io/guides/cdi-reference#bean_discovery"));
        }
    }
}

