/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImageSubresourceRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ASPECTMASK;
    public static final int BASEMIPLEVEL;
    public static final int LEVELCOUNT;
    public static final int BASEARRAYLAYER;
    public static final int LAYERCOUNT;

    public VkImageSubresourceRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkImageSubresourceRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImageAspectFlags")
    public int aspectMask() {
        return VkImageSubresourceRange.naspectMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseMipLevel() {
        return VkImageSubresourceRange.nbaseMipLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int levelCount() {
        return VkImageSubresourceRange.nlevelCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int baseArrayLayer() {
        return VkImageSubresourceRange.nbaseArrayLayer(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkImageSubresourceRange.nlayerCount(this.address());
    }

    public VkImageSubresourceRange aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
        VkImageSubresourceRange.naspectMask(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange baseMipLevel(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nbaseMipLevel(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange levelCount(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nlevelCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange baseArrayLayer(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nbaseArrayLayer(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange layerCount(@NativeType(value="uint32_t") int value) {
        VkImageSubresourceRange.nlayerCount(this.address(), value);
        return this;
    }

    public VkImageSubresourceRange set(int aspectMask, int baseMipLevel, int levelCount, int baseArrayLayer, int layerCount) {
        this.aspectMask(aspectMask);
        this.baseMipLevel(baseMipLevel);
        this.levelCount(levelCount);
        this.baseArrayLayer(baseArrayLayer);
        this.layerCount(layerCount);
        return this;
    }

    public VkImageSubresourceRange set(VkImageSubresourceRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkImageSubresourceRange malloc() {
        return (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkImageSubresourceRange calloc() {
        return (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkImageSubresourceRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkImageSubresourceRange create(long address) {
        return (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)address);
    }

    @Nullable
    public static VkImageSubresourceRange createSafe(long address) {
        return address == 0L ? null : (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkImageSubresourceRange.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageSubresourceRange.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkImageSubresourceRange mallocStack() {
        return VkImageSubresourceRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresourceRange callocStack() {
        return VkImageSubresourceRange.callocStack(MemoryStack.stackGet());
    }

    public static VkImageSubresourceRange mallocStack(MemoryStack stack) {
        return (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkImageSubresourceRange callocStack(MemoryStack stack) {
        return (VkImageSubresourceRange)VkImageSubresourceRange.wrap(VkImageSubresourceRange.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkImageSubresourceRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkImageSubresourceRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkImageSubresourceRange.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int naspectMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)ASPECTMASK);
    }

    public static int nbaseMipLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEMIPLEVEL);
    }

    public static int nlevelCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LEVELCOUNT);
    }

    public static int nbaseArrayLayer(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASEARRAYLAYER);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static void naspectMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ASPECTMASK, value);
    }

    public static void nbaseMipLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEMIPLEVEL, value);
    }

    public static void nlevelCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LEVELCOUNT, value);
    }

    public static void nbaseArrayLayer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASEARRAYLAYER, value);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    static {
        Struct.Layout layout = VkImageSubresourceRange.__struct((Struct.Member[])new Struct.Member[]{VkImageSubresourceRange.__member((int)4), VkImageSubresourceRange.__member((int)4), VkImageSubresourceRange.__member((int)4), VkImageSubresourceRange.__member((int)4), VkImageSubresourceRange.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ASPECTMASK = layout.offsetof(0);
        BASEMIPLEVEL = layout.offsetof(1);
        LEVELCOUNT = layout.offsetof(2);
        BASEARRAYLAYER = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkImageSubresourceRange, Buffer>
    implements NativeResource {
        private static final VkImageSubresourceRange ELEMENT_FACTORY = VkImageSubresourceRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkImageSubresourceRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImageAspectFlags")
        public int aspectMask() {
            return VkImageSubresourceRange.naspectMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseMipLevel() {
            return VkImageSubresourceRange.nbaseMipLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int levelCount() {
            return VkImageSubresourceRange.nlevelCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int baseArrayLayer() {
            return VkImageSubresourceRange.nbaseArrayLayer(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkImageSubresourceRange.nlayerCount(this.address());
        }

        public Buffer aspectMask(@NativeType(value="VkImageAspectFlags") int value) {
            VkImageSubresourceRange.naspectMask(this.address(), value);
            return this;
        }

        public Buffer baseMipLevel(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nbaseMipLevel(this.address(), value);
            return this;
        }

        public Buffer levelCount(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nlevelCount(this.address(), value);
            return this;
        }

        public Buffer baseArrayLayer(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nbaseArrayLayer(this.address(), value);
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkImageSubresourceRange.nlayerCount(this.address(), value);
            return this;
        }
    }
}

