/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPushConstantRange
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STAGEFLAGS;
    public static final int OFFSET;
    public static final int SIZE;

    public VkPushConstantRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPushConstantRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushConstantRange.nstageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkPushConstantRange.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int size() {
        return VkPushConstantRange.nsize(this.address());
    }

    public VkPushConstantRange stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushConstantRange.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushConstantRange offset(@NativeType(value="uint32_t") int value) {
        VkPushConstantRange.noffset(this.address(), value);
        return this;
    }

    public VkPushConstantRange size(@NativeType(value="uint32_t") int value) {
        VkPushConstantRange.nsize(this.address(), value);
        return this;
    }

    public VkPushConstantRange set(int stageFlags, int offset, int size) {
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.size(size);
        return this;
    }

    public VkPushConstantRange set(VkPushConstantRange src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPushConstantRange malloc() {
        return (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPushConstantRange calloc() {
        return (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPushConstantRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPushConstantRange create(long address) {
        return (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)address);
    }

    @Nullable
    public static VkPushConstantRange createSafe(long address) {
        return address == 0L ? null : (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPushConstantRange.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushConstantRange.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPushConstantRange mallocStack() {
        return VkPushConstantRange.mallocStack(MemoryStack.stackGet());
    }

    public static VkPushConstantRange callocStack() {
        return VkPushConstantRange.callocStack(MemoryStack.stackGet());
    }

    public static VkPushConstantRange mallocStack(MemoryStack stack) {
        return (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPushConstantRange callocStack(MemoryStack stack) {
        return (VkPushConstantRange)VkPushConstantRange.wrap(VkPushConstantRange.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPushConstantRange.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPushConstantRange.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPushConstantRange.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static int nsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)SIZE);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    public static void nsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = VkPushConstantRange.__struct((Struct.Member[])new Struct.Member[]{VkPushConstantRange.__member((int)4), VkPushConstantRange.__member((int)4), VkPushConstantRange.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STAGEFLAGS = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPushConstantRange, Buffer>
    implements NativeResource {
        private static final VkPushConstantRange ELEMENT_FACTORY = VkPushConstantRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPushConstantRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushConstantRange.nstageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkPushConstantRange.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int size() {
            return VkPushConstantRange.nsize(this.address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushConstantRange.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkPushConstantRange.noffset(this.address(), value);
            return this;
        }

        public Buffer size(@NativeType(value="uint32_t") int value) {
            VkPushConstantRange.nsize(this.address(), value);
            return this;
        }
    }
}

