/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH128_hash_t")
public class XXH128Hash
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOW64;
    public static final int HIGH64;

    public XXH128Hash(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH128Hash.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH32_hash_t")
    public long low64() {
        return XXH128Hash.nlow64(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public long high64() {
        return XXH128Hash.nhigh64(this.address());
    }

    public static XXH128Hash malloc() {
        return (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XXH128Hash calloc() {
        return (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XXH128Hash create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XXH128Hash create(long address) {
        return (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)address);
    }

    @Nullable
    public static XXH128Hash createSafe(long address) {
        return address == 0L ? null : (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XXH128Hash.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XXH128Hash.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XXH128Hash.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH128Hash.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XXH128Hash.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XXH128Hash.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XXH128Hash.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XXH128Hash mallocStack() {
        return XXH128Hash.mallocStack(MemoryStack.stackGet());
    }

    public static XXH128Hash callocStack() {
        return XXH128Hash.callocStack(MemoryStack.stackGet());
    }

    public static XXH128Hash mallocStack(MemoryStack stack) {
        return (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH128Hash callocStack(MemoryStack stack) {
        return (XXH128Hash)XXH128Hash.wrap(XXH128Hash.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH128Hash.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH128Hash.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH128Hash.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)XXH128Hash.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nlow64(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOW64);
    }

    public static long nhigh64(long struct) {
        return UNSAFE.getLong(null, struct + (long)HIGH64);
    }

    static {
        Struct.Layout layout = XXH128Hash.__struct((Struct.Member[])new Struct.Member[]{XXH128Hash.__member((int)8), XXH128Hash.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOW64 = layout.offsetof(0);
        HIGH64 = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XXH128Hash, Buffer>
    implements NativeResource {
        private static final XXH128Hash ELEMENT_FACTORY = XXH128Hash.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XXH128Hash getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH32_hash_t")
        public long low64() {
            return XXH128Hash.nlow64(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public long high64() {
            return XXH128Hash.nhigh64(this.address());
        }
    }
}

