/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.par;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.par.ParSLAnnotation;
import org.lwjgl.util.par.ParSLPosition;

@NativeType(value="struct parsl_mesh")
public class ParSLMesh
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUM_VERTICES;
    public static final int NUM_TRIANGLES;
    public static final int TRIANGLE_INDICES;
    public static final int POSITIONS;
    public static final int ANNOTATIONS;
    public static final int SPINE_LENGTHS;
    public static final int RANDOM_OFFSETS;

    public ParSLMesh(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ParSLMesh.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int num_vertices() {
        return ParSLMesh.nnum_vertices(this.address());
    }

    @NativeType(value="uint32_t")
    public int num_triangles() {
        return ParSLMesh.nnum_triangles(this.address());
    }

    @NativeType(value="uint32_t *")
    public IntBuffer triangle_indices(int capacity) {
        return ParSLMesh.ntriangle_indices(this.address(), capacity);
    }

    @NativeType(value="parsl_position *")
    public ParSLPosition.Buffer positions() {
        return ParSLMesh.npositions(this.address());
    }

    @Nullable
    @NativeType(value="parsl_annotation *")
    public ParSLAnnotation.Buffer annotations() {
        return ParSLMesh.nannotations(this.address());
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer spine_lengths() {
        return ParSLMesh.nspine_lengths(this.address());
    }

    @Nullable
    @NativeType(value="float *")
    public FloatBuffer random_offsets() {
        return ParSLMesh.nrandom_offsets(this.address());
    }

    public static ParSLMesh create(long address) {
        return (ParSLMesh)ParSLMesh.wrap(ParSLMesh.class, (long)address);
    }

    @Nullable
    public static ParSLMesh createSafe(long address) {
        return address == 0L ? null : (ParSLMesh)ParSLMesh.wrap(ParSLMesh.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)ParSLMesh.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)ParSLMesh.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int nnum_vertices(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_VERTICES);
    }

    public static int nnum_triangles(long struct) {
        return UNSAFE.getInt(null, struct + (long)NUM_TRIANGLES);
    }

    public static IntBuffer ntriangle_indices(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)TRIANGLE_INDICES)), (int)capacity);
    }

    public static ParSLPosition.Buffer npositions(long struct) {
        return ParSLPosition.create(MemoryUtil.memGetAddress((long)(struct + (long)POSITIONS)), ParSLMesh.nnum_vertices(struct));
    }

    @Nullable
    public static ParSLAnnotation.Buffer nannotations(long struct) {
        return ParSLAnnotation.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)ANNOTATIONS)), ParSLMesh.nnum_vertices(struct));
    }

    @Nullable
    public static FloatBuffer nspine_lengths(long struct) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)SPINE_LENGTHS)), (int)ParSLMesh.nnum_vertices(struct));
    }

    @Nullable
    public static FloatBuffer nrandom_offsets(long struct) {
        return MemoryUtil.memFloatBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)RANDOM_OFFSETS)), (int)ParSLMesh.nnum_vertices(struct));
    }

    static {
        Struct.Layout layout = ParSLMesh.__struct((Struct.Member[])new Struct.Member[]{ParSLMesh.__member((int)4), ParSLMesh.__member((int)4), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE), ParSLMesh.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUM_VERTICES = layout.offsetof(0);
        NUM_TRIANGLES = layout.offsetof(1);
        TRIANGLE_INDICES = layout.offsetof(2);
        POSITIONS = layout.offsetof(3);
        ANNOTATIONS = layout.offsetof(4);
        SPINE_LENGTHS = layout.offsetof(5);
        RANDOM_OFFSETS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<ParSLMesh, Buffer> {
        private static final ParSLMesh ELEMENT_FACTORY = ParSLMesh.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ParSLMesh getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int num_vertices() {
            return ParSLMesh.nnum_vertices(this.address());
        }

        @NativeType(value="uint32_t")
        public int num_triangles() {
            return ParSLMesh.nnum_triangles(this.address());
        }

        @NativeType(value="uint32_t *")
        public IntBuffer triangle_indices(int capacity) {
            return ParSLMesh.ntriangle_indices(this.address(), capacity);
        }

        @NativeType(value="parsl_position *")
        public ParSLPosition.Buffer positions() {
            return ParSLMesh.npositions(this.address());
        }

        @Nullable
        @NativeType(value="parsl_annotation *")
        public ParSLAnnotation.Buffer annotations() {
            return ParSLMesh.nannotations(this.address());
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer spine_lengths() {
            return ParSLMesh.nspine_lengths(this.address());
        }

        @Nullable
        @NativeType(value="float *")
        public FloatBuffer random_offsets() {
            return ParSLMesh.nrandom_offsets(this.address());
        }
    }
}

