/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.remotery.LibRemotery;
import org.lwjgl.util.remotery.RMTSettings;

public class Remotery {
    public static final int RMT_ERROR_NONE = 0;
    public static final int RMT_ERROR_RECURSIVE_SAMPLE = 1;
    public static final int RMT_ERROR_MALLOC_FAIL = 2;
    public static final int RMT_ERROR_TLS_ALLOC_FAIL = 3;
    public static final int RMT_ERROR_VIRTUAL_MEMORY_BUFFER_FAIL = 4;
    public static final int RMT_ERROR_CREATE_THREAD_FAIL = 5;
    public static final int RMT_ERROR_SOCKET_INIT_NETWORK_FAIL = 6;
    public static final int RMT_ERROR_SOCKET_CREATE_FAIL = 7;
    public static final int RMT_ERROR_SOCKET_BIND_FAIL = 8;
    public static final int RMT_ERROR_SOCKET_LISTEN_FAIL = 9;
    public static final int RMT_ERROR_SOCKET_SET_NON_BLOCKING_FAIL = 10;
    public static final int RMT_ERROR_SOCKET_INVALID_POLL = 11;
    public static final int RMT_ERROR_SOCKET_SELECT_FAIL = 12;
    public static final int RMT_ERROR_SOCKET_POLL_ERRORS = 13;
    public static final int RMT_ERROR_SOCKET_ACCEPT_FAIL = 14;
    public static final int RMT_ERROR_SOCKET_SEND_TIMEOUT = 15;
    public static final int RMT_ERROR_SOCKET_SEND_FAIL = 16;
    public static final int RMT_ERROR_SOCKET_RECV_NO_DATA = 17;
    public static final int RMT_ERROR_SOCKET_RECV_TIMEOUT = 18;
    public static final int RMT_ERROR_SOCKET_RECV_FAILED = 19;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NOT_GET = 20;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NO_VERSION = 21;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_BAD_VERSION = 22;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NO_HOST = 23;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_BAD_HOST = 24;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_NO_KEY = 25;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_BAD_KEY = 26;
    public static final int RMT_ERROR_WEBSOCKET_HANDSHAKE_STRING_FAIL = 27;
    public static final int RMT_ERROR_WEBSOCKET_DISCONNECTED = 28;
    public static final int RMT_ERROR_WEBSOCKET_BAD_FRAME_HEADER = 29;
    public static final int RMT_ERROR_WEBSOCKET_BAD_FRAME_HEADER_SIZE = 30;
    public static final int RMT_ERROR_WEBSOCKET_BAD_FRAME_HEADER_MASK = 31;
    public static final int RMT_ERROR_WEBSOCKET_RECEIVE_TIMEOUT = 32;
    public static final int RMT_ERROR_REMOTERY_NOT_CREATED = 33;
    public static final int RMT_ERROR_SEND_ON_INCOMPLETE_PROFILE = 34;
    public static final int RMT_ERROR_CUDA_DEINITIALIZED = 35;
    public static final int RMT_ERROR_CUDA_NOT_INITIALIZED = 36;
    public static final int RMT_ERROR_CUDA_INVALID_CONTEXT = 37;
    public static final int RMT_ERROR_CUDA_INVALID_VALUE = 38;
    public static final int RMT_ERROR_CUDA_INVALID_HANDLE = 39;
    public static final int RMT_ERROR_CUDA_OUT_OF_MEMORY = 40;
    public static final int RMT_ERROR_ERROR_NOT_READY = 41;
    public static final int RMT_ERROR_D3D11_FAILED_TO_CREATE_QUERY = 42;
    public static final int RMT_ERROR_OPENGL_ERROR = 43;
    public static final int RMT_ERROR_CUDA_UNKNOWN = 44;
    public static final int RMTSF_None = 0;
    public static final int RMTSF_Aggregate = 1;
    public static final int RMTSF_Recursive = 2;

    protected Remotery() {
        throw new UnsupportedOperationException();
    }

    public static native long nrmt_Settings();

    @Nullable
    @NativeType(value="rmtSettings *")
    public static RMTSettings rmt_Settings() {
        long __result = Remotery.nrmt_Settings();
        return RMTSettings.createSafe(__result);
    }

    public static native int nrmt_CreateGlobalInstance(long var0);

    @NativeType(value="rmtError")
    public static int rmt_CreateGlobalInstance(@NativeType(value="Remotery **") PointerBuffer remotery) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)remotery, (int)1);
        }
        return Remotery.nrmt_CreateGlobalInstance(MemoryUtil.memAddress((CustomBuffer)remotery));
    }

    public static native void nrmt_DestroyGlobalInstance(long var0);

    public static void rmt_DestroyGlobalInstance(@NativeType(value="Remotery *") long remotery) {
        if (Checks.CHECKS) {
            Checks.check((long)remotery);
        }
        Remotery.nrmt_DestroyGlobalInstance(remotery);
    }

    public static native void nrmt_SetGlobalInstance(long var0);

    public static void rmt_SetGlobalInstance(@NativeType(value="Remotery *") long remotery) {
        if (Checks.CHECKS) {
            Checks.check((long)remotery);
        }
        Remotery.nrmt_SetGlobalInstance(remotery);
    }

    @NativeType(value="Remotery *")
    public static native long rmt_GetGlobalInstance();

    public static native void nrmt_SetCurrentThreadName(long var0);

    public static void rmt_SetCurrentThreadName(@NativeType(value="rmtPStr") ByteBuffer thread_name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)thread_name);
        }
        Remotery.nrmt_SetCurrentThreadName(MemoryUtil.memAddress((ByteBuffer)thread_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_SetCurrentThreadName(@NativeType(value="rmtPStr") CharSequence thread_name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(thread_name, true);
            long thread_nameEncoded = stack.getPointerAddress();
            Remotery.nrmt_SetCurrentThreadName(thread_nameEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nrmt_LogText(long var0);

    public static void rmt_LogText(@NativeType(value="rmtPStr") ByteBuffer text) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)text);
        }
        Remotery.nrmt_LogText(MemoryUtil.memAddress((ByteBuffer)text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_LogText(@NativeType(value="rmtPStr") CharSequence text) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(text, true);
            long textEncoded = stack.getPointerAddress();
            Remotery.nrmt_LogText(textEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nrmt_BeginCPUSample(long var0, int var2, long var3);

    public static void rmt_BeginCPUSample(@NativeType(value="rmtPStr") ByteBuffer name, @NativeType(value="rmtU32") int flags, @Nullable @NativeType(value="rmtU32 *") IntBuffer hash_cache) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)name);
            Checks.checkSafe((Buffer)hash_cache, (int)1);
        }
        Remotery.nrmt_BeginCPUSample(MemoryUtil.memAddress((ByteBuffer)name), flags, MemoryUtil.memAddressSafe((IntBuffer)hash_cache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rmt_BeginCPUSample(@NativeType(value="rmtPStr") CharSequence name, @NativeType(value="rmtU32") int flags, @Nullable @NativeType(value="rmtU32 *") IntBuffer hash_cache) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)hash_cache, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(name, true);
            long nameEncoded = stack.getPointerAddress();
            Remotery.nrmt_BeginCPUSample(nameEncoded, flags, MemoryUtil.memAddressSafe((IntBuffer)hash_cache));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void rmt_EndCPUSample();

    static {
        LibRemotery.initialize();
    }
}

