"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPerPanelMap = void 0;
function getPerPanelMap(scales, fn) {
    var horizontal = scales.horizontal, vertical = scales.vertical;
    return vertical.domain.reduce(function (acc, verticalValue) {
        return __spread(acc, horizontal.domain.reduce(function (hAcc, horizontalValue) {
            var _a, _b;
            var panelAnchor = {
                x: (_a = horizontal.scale(horizontalValue)) !== null && _a !== void 0 ? _a : 0,
                y: (_b = vertical.scale(verticalValue)) !== null && _b !== void 0 ? _b : 0,
            };
            var fnObj = fn(panelAnchor, horizontalValue, verticalValue, scales);
            if (!fnObj) {
                return hAcc;
            }
            return __spread(hAcc, [
                __assign({ panelAnchor: panelAnchor,
                    horizontalValue: horizontalValue,
                    verticalValue: verticalValue }, fnObj),
            ]);
        }, []));
    }, []);
}
exports.getPerPanelMap = getPerPanelMap;
//# sourceMappingURL=panel_utils.js.map