/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.samplerows;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.samplerows.Messages;
import org.pentaho.di.trans.steps.samplerows.SampleRowsData;
import org.pentaho.di.trans.steps.samplerows.SampleRowsMeta;

public class SampleRows
extends BaseStep
implements StepInterface {
    private SampleRowsMeta meta;
    private SampleRowsData data;

    public SampleRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (SampleRowsMeta)smi;
        this.data = (SampleRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            String realRange = this.environmentSubstitute(this.meta.getLinesRange());
            this.data.addlineField = !Const.isEmpty((String)this.environmentSubstitute(this.meta.getLineNumberField()));
            this.data.previousRowMeta = this.getInputRowMeta().clone();
            this.data.NrPrevFields = this.data.previousRowMeta.size();
            this.data.outputRowMeta = this.data.previousRowMeta;
            if (this.data.addlineField) {
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
            String[] rangePart = realRange.split(",");
            for (int i = 0; i < rangePart.length; ++i) {
                if (rangePart[i].matches("\\d+")) {
                    int vpart;
                    String part = rangePart[i];
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), Messages.getString("SampleRows.Log.RangeValue", part), new Object[0]);
                    }
                    if ((vpart = Integer.valueOf(part).intValue()) > this.data.maxLine) {
                        this.data.maxLine = vpart;
                    }
                    this.data.range.add(vpart);
                    continue;
                }
                if (!rangePart[i].matches("\\d+\\.\\.\\d+")) continue;
                String[] rangeMultiPart = rangePart[i].split("\\.\\.");
                for (int j = Integer.valueOf(rangeMultiPart[0]).intValue(); j < Integer.valueOf(rangeMultiPart[1]) + 1; ++j) {
                    int vpart;
                    if (this.log.isDebug()) {
                        this.log.logDebug(this.toString(), Messages.getString("SampleRows.Log.RangeValue", "" + j), new Object[0]);
                    }
                    if ((vpart = Integer.valueOf(j).intValue()) > this.data.maxLine) {
                        this.data.maxLine = vpart;
                    }
                    this.data.range.add(vpart);
                }
            }
        }
        if (this.data.addlineField) {
            this.data.outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            for (int i = 0; i < this.data.NrPrevFields; ++i) {
                this.data.outputRow[i] = r[i];
            }
        } else {
            this.data.outputRow = r;
        }
        if (this.data.range.contains((int)this.getLinesRead())) {
            if (this.data.addlineField) {
                this.data.outputRow[this.data.NrPrevFields] = this.getLinesRead();
            }
            this.putRow(this.data.outputRowMeta, this.data.outputRow);
            if (this.log.isRowLevel()) {
                this.log.logRowlevel(this.toString(), Messages.getString("SampleRows.Log.LineNumber", this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)), new Object[0]);
            }
        }
        if (this.data.maxLine > 0 && this.getLinesRead() >= (long)this.data.maxLine) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (SampleRowsMeta)smi;
        this.data = (SampleRowsData)sdi;
        return super.init(smi, sdi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                if (this.log.isBasic()) {
                    this.logBasic(Messages.getString("SampleRows.Log.StartingToRun"));
                }
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                Object var3_1 = null;
            }
            catch (Exception e) {
                this.logError(Messages.getString("SampleRows.Log.UnexpectedError") + " : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.dispose(this.meta, this.data);
        this.logSummary();
        this.markStop();
    }
}

