/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlaveServerTransStatus {
    public static final String XML_TAG = "transstatus";
    private String transName;
    private String statusDescription;
    private String errorDescription;
    private String loggingString;
    private List<StepStatus> stepStatusList = new ArrayList<StepStatus>();
    private Result result;
    private boolean paused;

    public SlaveServerTransStatus() {
    }

    public SlaveServerTransStatus(String transName, String statusDescription) {
        this();
        this.transName = transName;
        this.statusDescription = statusDescription;
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<transstatus>").append(Const.CR);
        xml.append(XMLHandler.addTagValue((String)"transname", (String)this.transName));
        xml.append(XMLHandler.addTagValue((String)"status_desc", (String)this.statusDescription));
        xml.append(XMLHandler.addTagValue((String)"error_desc", (String)this.errorDescription));
        xml.append(XMLHandler.addTagValue((String)"paused", (boolean)this.paused));
        xml.append("  <stepstatuslist>").append(Const.CR);
        for (int i = 0; i < this.stepStatusList.size(); ++i) {
            StepStatus stepStatus = this.stepStatusList.get(i);
            xml.append("    ").append(stepStatus.getXML()).append(Const.CR);
        }
        xml.append("  </stepstatuslist>").append(Const.CR);
        xml.append(XMLHandler.addTagValue((String)"logging_string", (String)XMLHandler.buildCDATA((String)this.loggingString)));
        if (this.result != null) {
            try {
                String resultXML = this.result.getXML();
                xml.append(resultXML);
            }
            catch (IOException e) {
                LogWriter.getInstance().logError("Slave server transformation status", "Unable to serialize result object as XML", (Throwable)e);
            }
        }
        xml.append("</transstatus>");
        return xml.toString();
    }

    public SlaveServerTransStatus(Node transStatusNode) {
        this();
        this.transName = XMLHandler.getTagValue((Node)transStatusNode, (String)"transname");
        this.statusDescription = XMLHandler.getTagValue((Node)transStatusNode, (String)"status_desc");
        this.errorDescription = XMLHandler.getTagValue((Node)transStatusNode, (String)"error_desc");
        this.paused = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)transStatusNode, (String)"paused"));
        Node statusListNode = XMLHandler.getSubNode((Node)transStatusNode, (String)"stepstatuslist");
        int nr = XMLHandler.countNodes((Node)statusListNode, (String)"stepstatus");
        for (int i = 0; i < nr; ++i) {
            Node stepStatusNode = XMLHandler.getSubNodeByNr((Node)statusListNode, (String)"stepstatus", (int)i);
            StepStatus stepStatus = new StepStatus(stepStatusNode);
            this.stepStatusList.add(stepStatus);
        }
        String loggingString64 = XMLHandler.getTagValue((Node)transStatusNode, (String)"logging_string");
        try {
            byte[] bytes = new byte[]{};
            if (loggingString64 != null) {
                bytes = Base64.decodeBase64((byte[])loggingString64.getBytes());
            }
            if (bytes.length > 0) {
                int c;
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                GZIPInputStream gzip = new GZIPInputStream(bais);
                StringBuffer buffer = new StringBuffer();
                while ((c = gzip.read()) != -1) {
                    buffer.append((char)c);
                }
                gzip.close();
                this.loggingString = buffer.toString();
            } else {
                this.loggingString = "";
            }
        }
        catch (IOException e) {
            this.loggingString = "Unable to decode logging from remote server : " + e.toString() + Const.CR + Const.getStackTracker((Throwable)e);
        }
        Node resultNode = XMLHandler.getSubNode((Node)transStatusNode, (String)"result");
        if (resultNode != null) {
            try {
                this.result = new Result(resultNode);
            }
            catch (IOException e) {
                this.loggingString = this.loggingString + "Unable to serialize result object as XML" + Const.CR + Const.getStackTracker((Throwable)e) + Const.CR;
            }
        }
    }

    public static SlaveServerTransStatus fromXML(String xml) throws KettleXMLException {
        Document document = XMLHandler.loadXMLString((String)xml);
        SlaveServerTransStatus status = new SlaveServerTransStatus(XMLHandler.getSubNode((Node)document, (String)XML_TAG));
        return status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public List<StepStatus> getStepStatusList() {
        return this.stepStatusList;
    }

    public void setStepStatusList(List<StepStatus> stepStatusList) {
        this.stepStatusList = stepStatusList;
    }

    public String getLoggingString() {
        return this.loggingString;
    }

    public void setLoggingString(String loggingString) {
        this.loggingString = loggingString;
    }

    public boolean isRunning() {
        return this.getStatusDescription().equalsIgnoreCase("Running") || this.getStatusDescription().equalsIgnoreCase("Initializing");
    }

    public long getNrStepErrors() {
        long errors = 0L;
        for (int i = 0; i < this.stepStatusList.size(); ++i) {
            StepStatus stepStatus = this.stepStatusList.get(i);
            errors += stepStatus.getErrors();
        }
        return errors;
    }

    public Result getResult(TransMeta transMeta) {
        Result result = new Result();
        for (StepStatus stepStatus : this.stepStatusList) {
            result.setNrErrors(result.getNrErrors() + stepStatus.getErrors() + (long)(result.isStopped() ? 1 : 0));
            if (transMeta.getReadStep() != null && stepStatus.getStepname().equals(transMeta.getReadStep().getName())) {
                result.setNrLinesRead(result.getNrLinesRead() + stepStatus.getLinesRead());
            }
            if (transMeta.getInputStep() != null && stepStatus.getStepname().equals(transMeta.getInputStep().getName())) {
                result.setNrLinesInput(result.getNrLinesInput() + stepStatus.getLinesInput());
            }
            if (transMeta.getWriteStep() != null && stepStatus.getStepname().equals(transMeta.getWriteStep().getName())) {
                result.setNrLinesWritten(result.getNrLinesWritten() + stepStatus.getLinesWritten());
            }
            if (transMeta.getOutputStep() != null && stepStatus.getStepname().equals(transMeta.getOutputStep().getName())) {
                result.setNrLinesOutput(result.getNrLinesOutput() + stepStatus.getLinesOutput());
            }
            if (transMeta.getUpdateStep() != null && stepStatus.getStepname().equals(transMeta.getUpdateStep().getName())) {
                result.setNrLinesUpdated(result.getNrLinesUpdated() + stepStatus.getLinesUpdated());
            }
            if (transMeta.getRejectedStep() != null && stepStatus.getStepname().equals(transMeta.getRejectedStep().getName())) {
                result.setNrLinesRejected(result.getNrLinesRejected() + stepStatus.getLinesRejected());
            }
            if (!stepStatus.isStopped()) continue;
            result.setStopped(true);
            result.setResult(false);
        }
        return result;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

