/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.util.StringUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public abstract class AbstractImg3Tag
implements StructConverter {
    protected BinaryReader _reader;
    protected int magic;
    protected int totalLength;
    protected int dataLength;

    protected AbstractImg3Tag(BinaryReader reader) throws IOException {
        this._reader = reader;
        this.magic = reader.readNextInt();
        this.totalLength = reader.readNextInt();
        this.dataLength = reader.readNextInt();
    }

    public String getMagic() {
        return StringUtilities.toString((int)this.magic);
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

