/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.prelink;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.prelink.PrelinkMap;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.MachoPrelinkUtils;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.GFileSystemProgramProvider;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.macosx.MacosxLanguageHelper;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Conv;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.BidiMap;
import org.jdom.JDOMException;

@FileSystemInfo(type="iosprelink", description="iOS Prelink", priority=10, factory=GFileSystemBaseFactory.class)
public class PrelinkFileSystem
extends GFileSystemBase
implements GFileSystemProgramProvider {
    public static final String IOS_PRELINK_FSTYPE = "iosprelink";
    private static final String SYSTEM_KEXT = "System.kext";
    private Map<GFile, PrelinkMap> fileToPrelinkInfoMap = new HashMap<GFile, PrelinkMap>();
    private Map<Long, GFileImpl> unnamedMachoFileMap = new HashMap<Long, GFileImpl>();
    private Map<GFile, Long> fileToMachoOffsetMap = new HashMap<GFile, Long>();
    private GFileImpl systemKextFile;
    private GFileImpl kernelCacheDirectory;

    public PrelinkFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        super.close();
        this.fileToPrelinkInfoMap.clear();
        this.unnamedMachoFileMap.clear();
        this.fileToMachoOffsetMap.clear();
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        try {
            return !MachoPrelinkUtils.parsePrelinkXml((ByteProvider)this.provider, (TaskMonitor)monitor).isEmpty();
        }
        catch (JDOMException e) {
            Msg.warn((Object)((Object)this), (Object)e.getMessage());
            return true;
        }
        catch (IOException e) {
            Msg.warn((Object)((Object)this), (Object)e.getMessage());
            return false;
        }
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        monitor.setMessage("Opening PRELINK file...");
        if (this.isContainerAlreadyNestedInsideAPrelinkFS()) {
            throw new IOException("Unable to open nested PRELINK file systems.");
        }
        List machoHeaderOffsets = MachoPrelinkUtils.findPrelinkMachoHeaderOffsets((ByteProvider)this.provider, (TaskMonitor)monitor);
        try {
            List prelinkList = MachoPrelinkUtils.parsePrelinkXml((ByteProvider)this.provider, (TaskMonitor)monitor);
            if (!prelinkList.isEmpty()) {
                this.processPrelinkWithMacho(prelinkList, machoHeaderOffsets, monitor);
            }
        }
        catch (JDOMException e) {
            this.processKModInfoStructures(machoHeaderOffsets, monitor);
        }
        catch (MachException e) {
            throw new IOException(e.getMessage());
        }
        if (this.systemKextFile != null) {
            this.systemKextFile.setLength(this.provider.length());
        }
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        PrelinkMap info = this.fileToPrelinkInfoMap.get(file);
        return info != null ? info.toString() : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals(this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.fileToPrelinkInfoMap.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals(this.root)) continue;
                roots.add(file);
            }
            if (this.kernelCacheDirectory != null) {
                roots.add((GFile)this.kernelCacheDirectory);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.fileToPrelinkInfoMap.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals(directory)) continue;
            tmp.add(file);
        }
        if (this.kernelCacheDirectory != null && this.kernelCacheDirectory.equals((Object)directory)) {
            ArrayList<Long> list = new ArrayList<Long>(this.unnamedMachoFileMap.keySet());
            Collections.sort(list);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                long offset = (Long)iterator.next();
                tmp.add((GFile)this.unnamedMachoFileMap.get(offset));
            }
        }
        return tmp;
    }

    public boolean canProvideProgram(GFile file) {
        return this.fileToMachoOffsetMap.get(file) != null;
    }

    public Program getProgram(GFile file, LanguageService languageService, TaskMonitor monitor, Object consumer) throws Exception {
        Long offset = this.fileToMachoOffsetMap.get(file);
        if (offset == null) {
            return null;
        }
        MachHeader machHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)this.provider, (long)offset, (boolean)true);
        LanguageCompilerSpecPair lcs = MacosxLanguageHelper.getLanguageCompilerSpecPair(languageService, machHeader.getCpuType(), machHeader.getCpuSubType());
        ProgramDB program = new ProgramDB(file.getName(), lcs.getLanguage(), lcs.getCompilerSpec(), consumer);
        int id = program.startTransaction(this.getName());
        boolean success = false;
        try {
            FileBytes fileBytes = MemoryBlockUtils.createFileBytes((Program)program, (ByteProvider)this.provider, (long)offset, (long)(this.provider.length() - offset), (TaskMonitor)monitor);
            ByteProviderWrapper providerWrapper = new ByteProviderWrapper(this.provider, offset.longValue(), this.provider.length() - offset);
            MachoProgramBuilder.buildProgram((Program)program, (ByteProvider)providerWrapper, (FileBytes)fileBytes, (MessageLog)new MessageLog(), (TaskMonitor)monitor);
            program.setExecutableFormat("Mac OS X Mach-O");
            program.setExecutablePath(file.getPath());
            if (file.equals(this.systemKextFile)) {
                this.processSystemKext(languageService, (Program)program, monitor);
            }
            success = true;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            program.endTransaction(id, success);
            if (!success) {
                program.release(consumer);
            }
        }
        return program;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (this.isChildOf((GFile)this.systemKextFile, file)) {
            throw new IOException("Unable to open " + file.getName() + ", it is already contained inside " + this.systemKextFile.getName());
        }
        Long offset = this.fileToMachoOffsetMap.get(file);
        if (offset == null) {
            return null;
        }
        return new ByteProviderInputStream(this.provider, offset.longValue(), this.provider.length() - offset);
    }

    private boolean isContainerAlreadyNestedInsideAPrelinkFS() {
        FSRL container = this.getFSRL().getFS().getContainer();
        return container != null && container.getFS().getProtocol().equals(IOS_PRELINK_FSTYPE);
    }

    private void processPrelinkWithMacho(List<PrelinkMap> prelinkList, List<Long> machoHeaderOffsets, TaskMonitor monitor) throws IOException, MachException {
        monitor.setMessage("Processing PRELINK with found Mach-O headers...");
        monitor.initialize((long)prelinkList.size());
        BidiMap map = MachoPrelinkUtils.matchPrelinkToMachoHeaderOffsets((ByteProvider)this.provider, prelinkList, machoHeaderOffsets, (TaskMonitor)monitor);
        for (PrelinkMap info : map.keySet()) {
            if (monitor.isCancelled()) break;
            monitor.incrementProgress(1L);
            if (info.getPrelinkBundlePath() == null) continue;
            GFileImpl file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)info.getPrelinkBundlePath(), null, (boolean)false, (long)0L);
            if (info.getPrelinkExecutableSize() > -1L) {
                file.setLength(info.getPrelinkExecutableSize());
            }
            if (this.isChildOf((GFile)this.systemKextFile, (GFile)(file = this.storeFile(file, info)))) continue;
            this.fileToMachoOffsetMap.put((GFile)file, (Long)map.get((Object)info));
        }
    }

    private void processSystemKext(LanguageService languageService, Program systemProgram, TaskMonitor monitor) throws Exception {
        for (GFile file : this.fileToPrelinkInfoMap.keySet()) {
            PrelinkMap prelinkMap;
            if (monitor.isCancelled()) break;
            if (!this.isChildOf((GFile)this.systemKextFile, file) || (prelinkMap = this.fileToPrelinkInfoMap.get(file)) == null || prelinkMap.getPrelinkExecutableLoadAddr() == -1L) continue;
            Address address = systemProgram.getAddressFactory().getDefaultAddressSpace().getAddress(prelinkMap.getPrelinkExecutableLoadAddr());
            MemoryByteProvider systemKextProvider = new MemoryByteProvider(systemProgram.getMemory(), address);
            MachHeader machHeader = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)systemKextProvider, (long)0L, (boolean)false);
            machHeader.parse();
            Namespace namespace = systemProgram.getSymbolTable().createNameSpace(null, file.getName(), SourceType.IMPORTED);
            List commands = machHeader.getLoadCommands(SymbolTableCommand.class);
            for (SymbolTableCommand symbolTableCommand : commands) {
                List symbols = symbolTableCommand.getSymbols();
                for (NList symbol : symbols) {
                    if (monitor.isCancelled()) {
                        return;
                    }
                    Symbol sym = SymbolUtilities.getLabelOrFunctionSymbol((Program)systemProgram, (String)symbol.getString(), err -> Msg.error((Object)((Object)this), (Object)err));
                    if (sym == null) continue;
                    sym.setNamespace(namespace);
                }
            }
        }
    }

    private GFileImpl storeFile(GFileImpl file, PrelinkMap info) {
        if (file == null) {
            return file;
        }
        if (file.equals((Object)this.root)) {
            return file;
        }
        if (this.systemKextFile == null && file.getName().equals(SYSTEM_KEXT)) {
            this.systemKextFile = file;
            this.fileToMachoOffsetMap.put((GFile)file, 0L);
        }
        GFileImpl asFile = GFileImpl.fromFSRL((GFileSystem)this, (GFile)file.getParentFile(), (FSRL)file.getFSRL(), (boolean)false, (long)file.getLength());
        GFileImpl asDir = GFileImpl.fromFSRL((GFileSystem)this, (GFile)file.getParentFile(), (FSRL)file.getFSRL(), (boolean)true, (long)file.getLength());
        GFileImpl ret = file;
        if (this.fileToPrelinkInfoMap.containsKey(asDir) && this.fileToPrelinkInfoMap.get(asDir) == null) {
            this.fileToPrelinkInfoMap.put((GFile)asDir, info);
            ret = asDir;
        } else if (this.fileToPrelinkInfoMap.containsKey(asFile) && this.fileToPrelinkInfoMap.get(asFile) != null && file.isDirectory()) {
            PrelinkMap value = this.fileToPrelinkInfoMap.remove(asFile);
            this.fileToPrelinkInfoMap.put((GFile)asDir, value);
            Long offset = this.fileToMachoOffsetMap.remove(asFile);
            this.fileToMachoOffsetMap.put((GFile)asDir, offset);
            ret = asDir;
        } else if (this.fileToPrelinkInfoMap.get(file) == null) {
            this.fileToPrelinkInfoMap.put((GFile)file, info);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile((GFileImpl)parentFile, null);
        return ret;
    }

    private boolean isChildOf(GFile parent, GFile child) {
        if (child == null) {
            return false;
        }
        if (parent == null) {
            return false;
        }
        if (parent.equals(child)) {
            return false;
        }
        return child.getPath().indexOf(parent.getPath()) != -1;
    }

    private void processKModInfoStructures(List<Long> machoHeaderOffsets, TaskMonitor monitor) throws IOException {
        HashMap infoToMachoMap = new HashMap();
        this.kernelCacheDirectory = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"kernelcache", (boolean)true, (long)-1L, null);
        for (long machoHeaderOffset : machoHeaderOffsets) {
            if (monitor.isCancelled()) break;
            Object kextName = "Kext_0x" + Conv.toHexString((long)machoHeaderOffset) + ".kext";
            try {
                MachHeader header = MachHeader.createMachHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, (ByteProvider)this.provider, (long)machoHeaderOffset);
                header.parse();
                String name = this.findNameOfKext(header, monitor);
                if (name != null) {
                    kextName = name + ".kext";
                }
            }
            catch (Exception e) {
                Msg.debug((Object)((Object)this), (Object)("Exception while parsing: " + (String)kextName), (Throwable)e);
            }
            if (machoHeaderOffset == 0L) {
                kextName = SYSTEM_KEXT;
            }
            if (infoToMachoMap.containsValue(machoHeaderOffset)) continue;
            long length = this.provider.length() - machoHeaderOffset;
            GFileImpl file = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.kernelCacheDirectory, (String)kextName, (boolean)false, (long)length, null);
            this.unnamedMachoFileMap.put(machoHeaderOffset, file);
            this.fileToMachoOffsetMap.put((GFile)file, machoHeaderOffset);
        }
    }

    private String findNameOfKext(MachHeader header, TaskMonitor monitor) {
        block10: {
            String string;
            block11: {
                Section dataSection;
                SegmentCommand dataSegment = header.getSegment("__DATA");
                if (dataSegment == null || (dataSection = dataSegment.getSectionByName("__data")) == null || dataSection.getSize() >= 0x1000000L) break block10;
                InputStream dataStream = dataSection.getDataStream(header);
                try {
                    byte[] bytes = new byte[(int)dataSection.getSize()];
                    dataStream.read(bytes);
                    String string2 = new String(bytes);
                    int index = string2.indexOf("com.apple");
                    String kmodNameString = string2.substring(index, index + 64).trim();
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 0; i < kmodNameString.length(); ++i) {
                        char c = kmodNameString.charAt(i);
                        if (LocalFileSystem.isValidNameCharacter((char)c)) {
                            buffer.append(c);
                            continue;
                        }
                        buffer.append('_');
                    }
                    string = buffer.toString();
                    if (dataStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataStream != null) {
                            try {
                                dataStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        Msg.debug((Object)((Object)this), (Object)"Exception occurred while trying to find the name of kext", (Throwable)e);
                    }
                }
                dataStream.close();
            }
            return string;
        }
        return null;
    }
}

