/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx.analyzers;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class TestAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Test";
    private static final String DESCRIPTION = "This is a test analyzer.";
    private static final String UNWIND_INFO = "__unwind_info";

    public TestAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setDefaultEnablement(true);
        this.setPriority(AnalysisPriority.LOW_PRIORITY);
        this.setPrototype();
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address intermediateEndAddress;
        DataType dataType = this.getDataType();
        MemoryBlock block = program.getMemory().getBlock(UNWIND_INFO);
        Address currentAddress = block.getStart();
        while (!monitor.isCancelled() && (intermediateEndAddress = currentAddress.add((long)dataType.getLength())).compareTo((Object)block.getEnd()) <= 0) {
            try {
                Data data = program.getListing().createData(currentAddress, dataType);
                if (data.getLength() != dataType.getLength()) {
                    // empty if block
                }
                program.getListing().setComment(currentAddress, 3, "Address = " + currentAddress.toString());
                currentAddress = currentAddress.add((long)data.getLength());
            }
            catch (CodeUnitInsertionException e) {
                log.appendException((Throwable)e);
                return false;
            }
            catch (DataTypeConflictException e) {
                log.appendException((Throwable)e);
                return false;
            }
        }
        return true;
    }

    public boolean canAnalyze(Program program) {
        return this.checkIfMacho(program);
    }

    private boolean checkIfMacho(Program program) {
        return false;
    }

    private DataType getDataType() {
        StructureDataType structure = new StructureDataType("unwindStruct", 0);
        structure.add((DataType)new FloatDataType(), "a", "this is a float");
        structure.add((DataType)new DWordDataType(), "b", "this is a dword");
        structure.add((DataType)new DoubleDataType(), "c", "this is a double");
        return structure;
    }
}

