/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import ghidra.graph.job.AbstractAnimator;
import ghidra.graph.viewer.edge.VisualEdgeRenderer;
import java.util.function.Supplier;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.interpolation.PropertySetter;

public class EdgeHoverAnimator<V, E>
extends AbstractAnimator {
    private static final int MOTION_SPEED = 2000;
    private static final Supplier<Float> ANIMATED_DASHED_LINE_FLOAT_GIVER = () -> {
        long currentTimeMillis = System.currentTimeMillis();
        return Float.valueOf((float)(2000L - currentTimeMillis % 2000L) / 2000.0f);
    };
    private static final int SLEEP_AMOUNT_MILLISECONDS = 300;
    private static final int DURATION = 5000;
    private long lastPaintTime = System.nanoTime();
    private final VisualizationServer<V, E> primaryViewer;
    private final VisualizationServer<V, E> satelliteViewer;
    private final boolean useAnimation;

    public EdgeHoverAnimator(VisualizationServer<V, E> primaryViewer, VisualizationServer<V, E> satelliteViewer, boolean useAnimation) {
        this.primaryViewer = primaryViewer;
        this.satelliteViewer = satelliteViewer;
        this.useAnimation = useAnimation;
    }

    @Override
    protected Animator createAnimator() {
        if (!this.useAnimation) {
            return null;
        }
        Animator newAnimator = PropertySetter.createAnimator((int)5000, (Object)this, (String)"nextPaint", (Object[])new Integer[]{0, 5000});
        newAnimator.setAcceleration(0.0f);
        newAnimator.setDeceleration(0.8f);
        return newAnimator;
    }

    @Override
    protected void finished() {
        this.paintDashedLineOnce();
    }

    public void setNextPaint(int nextPaint) {
        long currentTime = System.nanoTime();
        long ellapsedMilliseconds = (currentTime - this.lastPaintTime) / 1000000L;
        if (ellapsedMilliseconds > 300L) {
            this.lastPaintTime = currentTime;
            this.paintDashedLineOnce();
        }
    }

    private void paintDashedLineOnce() {
        float newPaintOffset = ANIMATED_DASHED_LINE_FLOAT_GIVER.get().floatValue();
        this.updateRendererPaintOffset(this.primaryViewer, newPaintOffset);
        this.updateRendererPaintOffset(this.satelliteViewer, newPaintOffset);
        this.primaryViewer.repaint();
        this.satelliteViewer.repaint();
    }

    private void updateRendererPaintOffset(VisualizationServer<V, E> viewer, float newPaintOffset) {
        Renderer renderer = viewer.getRenderer();
        Renderer.Edge edgeRenderer = renderer.getEdgeRenderer();
        if (!(edgeRenderer instanceof VisualEdgeRenderer)) {
            return;
        }
        VisualEdgeRenderer functionGraphEdgeRenderer = (VisualEdgeRenderer)edgeRenderer;
        functionGraphEdgeRenderer.setDashingPatternOffset(newPaintOffset);
    }
}

