/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.edge;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeArrowRenderingSupport;
import edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public abstract class VisualEdgeRenderer<V extends VisualVertex, E extends VisualEdge<V>>
extends BasicEdgeRenderer<V, E> {
    private static final float HOVERED_PATH_STROKE_WIDTH = 8.0f;
    private static final float FOCUSED_PATH_STROKE_WIDTH = 4.0f;
    private static final float SELECTED_STROKE_WIDTH = 6.0f;
    private static final float EMPHASIZED_STOKE_WIDTH = 9.0f;
    private float dashingPatternOffset;
    private Color defaultBaseColor = Color.BLACK;
    private Color defaultHighlightColor = Color.GRAY;

    public void setDashingPatternOffset(float dashingPatterOffset) {
        this.dashingPatternOffset = dashingPatterOffset;
    }

    public void setBaseColor(Color color) {
        this.defaultBaseColor = color;
    }

    public Color getBaseColor(Graph<V, E> g, E e) {
        return this.defaultBaseColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.defaultHighlightColor = highlightColor;
    }

    public Color getHighlightColor(Graph<V, E> g, E e) {
        return this.defaultHighlightColor;
    }

    protected boolean isInHoveredVertexPath(E e) {
        return e.isInHoveredVertexPath();
    }

    protected boolean isInFocusedVertexPath(E e) {
        return e.isInFocusedVertexPath();
    }

    protected boolean isSelected(E e) {
        return e.isSelected();
    }

    protected boolean isEmphasiszed(E e) {
        return e.getEmphasis() != 0.0;
    }

    public void drawSimpleEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        Stroke saveStroke;
        Shape vs2;
        boolean arrowHit;
        Predicate predicate;
        boolean drawArrow;
        Stroke saveStroke2;
        Paint drawPaint;
        GraphicsDecorator gDecorator = rc.getGraphicsContext();
        Graphics2D graphicsCopy = (Graphics2D)gDecorator.create();
        GraphicsDecorator g = new GraphicsDecorator(graphicsCopy);
        double alpha = e.getAlpha();
        if (alpha < 1.0) {
            g.setComposite((Composite)AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), (float)alpha));
        }
        Graph graph = layout.getGraph();
        Pair endpoints = graph.getEndpoints(e);
        VisualVertex v1 = (VisualVertex)endpoints.getFirst();
        VisualVertex v2 = (VisualVertex)endpoints.getSecond();
        float scalex = (float)g.getTransform().getScaleX();
        float scaley = (float)g.getTransform().getScaleY();
        boolean isInHoveredPath = this.isInHoveredVertexPath(e);
        boolean isInFocusedPath = this.isInFocusedVertexPath(e);
        boolean isSelected = this.isSelected(e);
        boolean isEmphasized = this.isEmphasiszed(e);
        Color highlightColor = this.getHighlightColor(graph, e);
        Color baseColor = this.getBaseColor(graph, e);
        Color hoveredColor = highlightColor;
        Color focusedColor = baseColor;
        Color selectedColor = highlightColor.darker();
        Color selectedAccentColor = highlightColor;
        float scale = StrictMath.min(scalex, scaley);
        Point2D p1 = (Point2D)layout.apply((Object)v1);
        Point2D p2 = (Point2D)layout.apply((Object)v2);
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        p1 = multiLayerTransformer.transform(Layer.LAYOUT, p1);
        p2 = multiLayerTransformer.transform(Layer.LAYOUT, p2);
        float x1 = (float)p1.getX();
        float y1 = (float)p1.getY();
        float x2 = (float)p2.getX();
        float y2 = (float)p2.getY();
        boolean isLoop = v1.equals(v2);
        Rectangle deviceRectangle = null;
        JComponent vv = rc.getScreenDevice();
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        Shape vs1 = this.getCompactShape(rc, layout, v1);
        Shape edgeShape = this.getEdgeShape(rc, graph, e, x1, y1, x2, y2, isLoop, vs1);
        MutableTransformer vt = multiLayerTransformer.getTransformer(Layer.VIEW);
        if (vt instanceof LensTransformer) {
            vt = ((LensTransformer)vt).getDelegate();
        }
        Context context = Context.getInstance((Object)graph, e);
        boolean edgeHit = vt.transform(edgeShape).intersects(deviceRectangle);
        if (!edgeHit) {
            return;
        }
        Paint oldPaint = g.getPaint();
        BasicStroke hoverStroke = this.getHoveredPathStroke(e, scale);
        BasicStroke focusedStroke = this.getFocusedPathStroke(e, scale);
        BasicStroke selectedStroke = this.getSelectedStroke(e, scale);
        BasicStroke selectedAccentStroke = this.getSelectedAccentStroke(e, scale);
        BasicStroke empahsisStroke = this.getEmphasisStroke(e, scale);
        Paint fillPaint = (Paint)rc.getEdgeFillPaintTransformer().apply(e);
        if (fillPaint != null) {
            Stroke saveStroke3;
            g.setPaint(fillPaint);
            g.fill(edgeShape);
            if (isEmphasized) {
                saveStroke3 = g.getStroke();
                g.setPaint(fillPaint);
                g.setStroke((Stroke)empahsisStroke);
                g.fill(edgeShape);
                g.setStroke(saveStroke3);
            }
            if (isInHoveredPath) {
                saveStroke3 = g.getStroke();
                g.setPaint((Paint)hoveredColor);
                g.setStroke((Stroke)hoverStroke);
                g.fill(edgeShape);
                g.setStroke(saveStroke3);
            }
            if (isInFocusedPath) {
                saveStroke3 = g.getStroke();
                g.setPaint((Paint)focusedColor);
                g.setStroke((Stroke)focusedStroke);
                g.fill(edgeShape);
                g.setStroke(saveStroke3);
            }
            if (isSelected) {
                saveStroke3 = g.getStroke();
                g.setPaint((Paint)selectedColor);
                g.setStroke((Stroke)selectedStroke);
                g.fill(edgeShape);
                g.setStroke(saveStroke3);
            }
        }
        if ((drawPaint = (Paint)rc.getEdgeDrawPaintTransformer().apply(e)) != null) {
            g.setPaint(drawPaint);
            g.draw(edgeShape);
        }
        if (isEmphasized) {
            saveStroke2 = g.getStroke();
            g.setPaint(drawPaint);
            g.setStroke((Stroke)empahsisStroke);
            g.draw(edgeShape);
            g.setStroke(saveStroke2);
        }
        if (isInHoveredPath) {
            saveStroke2 = g.getStroke();
            g.setPaint((Paint)hoveredColor);
            g.setStroke((Stroke)hoverStroke);
            g.draw(edgeShape);
            g.setStroke(saveStroke2);
        }
        if (isInFocusedPath) {
            saveStroke2 = g.getStroke();
            g.setPaint((Paint)focusedColor);
            g.setStroke((Stroke)focusedStroke);
            g.draw(edgeShape);
            g.setStroke(saveStroke2);
        }
        if (isSelected) {
            saveStroke2 = g.getStroke();
            g.setPaint((Paint)selectedAccentColor);
            g.setStroke((Stroke)selectedAccentStroke);
            g.draw(edgeShape);
            g.setPaint((Paint)selectedColor);
            g.setStroke((Stroke)selectedStroke);
            g.draw(edgeShape);
            g.setStroke(saveStroke2);
        }
        if (!(drawArrow = (predicate = rc.getEdgeArrowPredicate()).apply((Object)context))) {
            g.setPaint(oldPaint);
            return;
        }
        Stroke arrowStroke = (Stroke)rc.getEdgeArrowStrokeTransformer().apply(e);
        Stroke oldArrowStroke = g.getStroke();
        if (arrowStroke != null) {
            g.setStroke(arrowStroke);
        }
        if (!(arrowHit = vt.transform(vs2 = this.getVertexShapeForArrow(rc, layout, v2)).intersects(deviceRectangle))) {
            g.setPaint(oldPaint);
            return;
        }
        BasicEdgeArrowRenderingSupport arrowRenderingSupport = new BasicEdgeArrowRenderingSupport();
        AffineTransform at = arrowRenderingSupport.getArrowTransform(rc, edgeShape, vs2);
        if (at == null) {
            g.setPaint(oldPaint);
            g.setStroke(oldArrowStroke);
            return;
        }
        Paint arrowFillPaint = (Paint)rc.getArrowFillPaintTransformer().apply(e);
        Paint arrowDrawPaint = (Paint)rc.getArrowDrawPaintTransformer().apply(e);
        Shape arrow = (Shape)rc.getEdgeArrowTransformer().apply((Object)context);
        arrow = this.scaleArrowForBetterVisibility(rc, arrow);
        arrow = at.createTransformedShape(arrow);
        g.setPaint(arrowFillPaint);
        g.fill(arrow);
        g.setPaint(arrowDrawPaint);
        g.draw(arrow);
        if (isEmphasized) {
            saveStroke = g.getStroke();
            g.setPaint(arrowDrawPaint);
            g.setStroke((Stroke)empahsisStroke);
            g.fill(arrow);
            g.draw(arrow);
            g.setStroke(saveStroke);
        }
        if (isInHoveredPath) {
            saveStroke = g.getStroke();
            g.setPaint((Paint)hoveredColor);
            g.setStroke((Stroke)hoverStroke);
            g.fill(arrow);
            g.draw(arrow);
            g.setStroke(saveStroke);
        }
        if (isInFocusedPath) {
            saveStroke = g.getStroke();
            g.setPaint((Paint)focusedColor);
            g.setStroke((Stroke)focusedStroke);
            g.draw(edgeShape);
            g.setStroke(saveStroke);
        }
        if (isSelected) {
            saveStroke = g.getStroke();
            g.setPaint((Paint)selectedColor);
            g.setStroke((Stroke)selectedStroke);
            g.fill(arrow);
            g.draw(arrow);
            g.setStroke(saveStroke);
        }
        g.setStroke(oldArrowStroke);
        g.setPaint(oldPaint);
    }

    protected Shape getVertexShapeForArrow(RenderContext<V, E> rc, Layout<V, E> layout, V v) {
        return this.getFullShape(rc, layout, v);
    }

    public abstract Shape getEdgeShape(RenderContext<V, E> var1, Graph<V, E> var2, E var3, float var4, float var5, float var6, float var7, boolean var8, Shape var9);

    private BasicStroke getHoveredPathStroke(E e, float scale) {
        float width = 8.0f / (float)Math.pow(scale, 0.8);
        return new BasicStroke(width, 1, 1, 0.0f, new float[]{width * 1.0f, width * 2.0f}, width * 3.0f * this.dashingPatternOffset);
    }

    private BasicStroke getFocusedPathStroke(E e, float scale) {
        float width = 4.0f / (float)Math.pow(scale, 0.8);
        return new BasicStroke(width);
    }

    private BasicStroke getSelectedStroke(E e, float scale) {
        float width = 6.0f / (float)Math.pow(scale, 0.8);
        return new BasicStroke(width);
    }

    private BasicStroke getSelectedAccentStroke(E e, float scale) {
        float width = 8.0f / (float)Math.pow(scale, 0.8);
        return new BasicStroke(width);
    }

    private BasicStroke getEmphasisStroke(E e, float scale) {
        double emphasisRatio = e.getEmphasis();
        float fullEmphasis = 9.0f;
        float emphasis = (float)((double)fullEmphasis * emphasisRatio);
        float width = emphasis / (float)Math.pow(scale, 0.8);
        return new BasicStroke(width);
    }

    private Shape scaleArrowForBetterVisibility(RenderContext<V, E> rc, Shape arrow) {
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        MutableTransformer viewTransformer = multiLayerTransformer.getTransformer(Layer.VIEW);
        double scaleX2 = viewTransformer.getScaleX();
        double scaleY2 = viewTransformer.getScaleY();
        AffineTransform fine = AffineTransform.getScaleInstance(1.0 / Math.pow(scaleX2, 0.68), 1.0 / Math.pow(scaleY2, 0.68));
        return fine.createTransformedShape(arrow);
    }

    public Shape getFullShape(RenderContext<V, E> rc, Layout<V, E> layout, V vertex) {
        Function vertexShaper = rc.getVertexShapeTransformer();
        Shape shape = null;
        if (vertexShaper instanceof VisualGraphVertexShapeTransformer) {
            VisualGraphVertexShapeTransformer vgShaper = (VisualGraphVertexShapeTransformer)vertexShaper;
            shape = vgShaper.transformToFullShape(vertex);
        } else {
            shape = (Shape)vertexShaper.apply(vertex);
        }
        return this.transformFromLayoutToView(rc, layout, vertex, shape);
    }

    protected Shape getCompactShape(RenderContext<V, E> rc, Layout<V, E> layout, V vertex) {
        Function vertexShaper = rc.getVertexShapeTransformer();
        Shape shape = null;
        if (vertexShaper instanceof VisualGraphVertexShapeTransformer) {
            VisualGraphVertexShapeTransformer vgShaper = (VisualGraphVertexShapeTransformer)vertexShaper;
            shape = vgShaper.transformToCompactShape(vertex);
        } else {
            shape = (Shape)vertexShaper.apply(vertex);
        }
        return this.transformFromLayoutToView(rc, layout, vertex, shape);
    }

    protected Shape transformFromLayoutToView(RenderContext<V, E> rc, Layout<V, E> layout, V vertex, Shape shape) {
        Point2D p = (Point2D)layout.apply(vertex);
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        p = multiLayerTransformer.transform(Layer.LAYOUT, p);
        float x = (float)p.getX();
        float y = (float)p.getY();
        AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
        return xform.createTransformedShape(shape);
    }
}

