/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.filechooser.DirectoryListModel;
import docking.widgets.filechooser.FileListCellRenderer;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserDirectoryModelIf;
import docking.widgets.label.GDLabel;
import docking.widgets.list.GList;
import ghidra.util.exception.AssertException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class DirectoryList
extends GList<File>
implements GhidraFileChooserDirectoryModelIf {
    private static final int DEFAULT_ICON_SIZE = 16;
    private static final int WIDTH_PADDING = 14;
    private static final int HEIGHT_PADDING = 5;
    private GhidraFileChooser chooser;
    private DirectoryListModel model;
    private FileListCellRenderer cellRenderer;
    private JLabel listEditorLabel;
    private JTextField listEditorField;
    private JPanel listEditor;
    private File editedFile;

    DirectoryList(GhidraFileChooser chooser, DirectoryListModel model) {
        super(model);
        this.chooser = chooser;
        this.model = model;
        this.build();
    }

    private void build() {
        this.setLayoutOrientation(1);
        this.cellRenderer = new FileListCellRenderer(this.getFont(), this.chooser);
        this.setCellRenderer(this.cellRenderer);
        this.model.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                DirectoryList.this.recomputeListCellDimensions(null);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                DirectoryList.this.recomputeListCellDimensions(null);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this.addMouseListener(new GMouseListenerAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                DirectoryList.this.listEditor.setVisible(false);
                DirectoryList.this.requestFocus();
            }

            @Override
            public boolean shouldConsume(MouseEvent e) {
                return e.isPopupTrigger() && DirectoryList.this.isEditing();
            }

            @Override
            public void popupTriggered(MouseEvent e) {
                DirectoryList.this.maybeSelectItem(e);
            }

            @Override
            public void doubleClickTriggered(MouseEvent e) {
                DirectoryList.this.handleDoubleClick();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    return;
                }
                e.consume();
                int[] selectedIndices = DirectoryList.this.getSelectedIndices();
                if (selectedIndices.length == 0) {
                    DirectoryList.this.chooser.okCallback();
                    return;
                }
                if (selectedIndices.length > 1) {
                    DirectoryList.this.chooser.okCallback();
                    return;
                }
                File file = DirectoryList.this.model.getFile(selectedIndices[0]);
                if (DirectoryList.this.chooser.getModel().isDirectory(file)) {
                    DirectoryList.this.chooser.setCurrentDirectory(file);
                } else {
                    DirectoryList.this.chooser.userChoseFile(file);
                }
            }
        });
        this.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.updateChooserForSelection();
        });
        this.listEditorLabel = new GDLabel();
        this.listEditorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = DirectoryList.this.locationToIndex(new Point(DirectoryList.this.listEditor.getX(), DirectoryList.this.listEditor.getY()));
                File file = DirectoryList.this.model.getFile(index);
                if (e.getClickCount() == 2) {
                    if (DirectoryList.this.chooser.getModel().isDirectory(file)) {
                        DirectoryList.this.chooser.setCurrentDirectory(file);
                    }
                    DirectoryList.this.cancelListEdit();
                }
            }
        });
        this.listEditorField = new JTextField();
        this.listEditorField.setName("LIST_EDITOR_FIELD");
        this.listEditorField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DirectoryList.this.cancelListEdit();
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DirectoryList.this.listEditor.setVisible(false);
                    e.consume();
                } else if (e.getKeyCode() == 10) {
                    String invalidFilenameMessage = DirectoryList.this.chooser.getInvalidFilenameMessage(DirectoryList.this.listEditorField.getText());
                    if (invalidFilenameMessage != null) {
                        DirectoryList.this.chooser.setStatusText(invalidFilenameMessage);
                    } else {
                        DirectoryList.this.stopListEdit();
                    }
                    e.consume();
                }
            }
        });
        this.listEditorField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DirectoryList.this.stopListEdit();
            }
        });
        this.listEditor = new JPanel(new BorderLayout());
        this.listEditor.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.listEditor.add((Component)this.listEditorLabel, "West");
        this.listEditor.add((Component)this.listEditorField, "Center");
        this.listEditor.setBackground(Color.WHITE);
        this.listEditorField.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.add(this.listEditor);
    }

    private void maybeSelectItem(MouseEvent e) {
        Point point = e.getPoint();
        int index = this.locationToIndex(point);
        if (index < 0) {
            return;
        }
        this.setSelectedIndex(index);
    }

    private void handleDoubleClick() {
        int[] selectedIndices;
        ArrayList<File> selectedFiles = new ArrayList<File>();
        for (int i : selectedIndices = this.getSelectedIndices()) {
            selectedFiles.add(this.model.getFile(i));
        }
        if (selectedFiles.size() == 0 || selectedFiles.size() > 1) {
            return;
        }
        File file = (File)selectedFiles.get(0);
        if (this.chooser.getModel().isDirectory(file)) {
            this.chooser.setCurrentDirectory(file);
        } else {
            this.chooser.userChoseFile(file);
        }
    }

    private void updateChooserForSelection() {
        int[] selectedIndices;
        ArrayList<File> selectedFiles = new ArrayList<File>();
        for (int index : selectedIndices = this.getSelectedIndices()) {
            selectedFiles.add(this.model.getFile(index));
        }
        this.chooser.userSelectedFiles(selectedFiles);
    }

    @Override
    public int[] getSelectedRows() {
        return this.getSelectedIndices();
    }

    @Override
    public File getSelectedFile() {
        int index = this.getSelectedIndex();
        if (index < 0) {
            return null;
        }
        return this.model.getFile(index);
    }

    @Override
    public File getFile(int row) {
        return this.model.getFile(row);
    }

    @Override
    public void edit() {
        int index = this.getSelectedIndex();
        this.editListCell(index);
    }

    @Override
    public void setSelectedFile(File file) {
        File selectedFile;
        int[] selectedIndices = this.getSelectedIndices();
        if (selectedIndices.length == 1 && (selectedFile = this.model.getFile(selectedIndices[0])).equals(file)) {
            return;
        }
        for (int i = 0; i < this.model.getSize(); ++i) {
            File aFile = this.model.getFile(i);
            if (aFile == null || !aFile.equals(file)) continue;
            this.setSelectedIndex(i);
            Rectangle rect = this.getCellBounds(i, i);
            this.scrollRectToVisible(rect);
            return;
        }
    }

    void setSelectedFiles(Iterable<File> files) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (File f : files) {
            indexes.add(this.model.indexOfFile(f));
        }
        int[] indices = new int[indexes.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)indexes.get(i);
        }
        this.setSelectedIndices(indices);
    }

    private boolean isEditing() {
        return this.editedFile != null;
    }

    void editListCell(int index) {
        if (index == -1) {
            return;
        }
        this.add(this.listEditor);
        Rectangle r = this.getCellBounds(index, index);
        this.editedFile = this.model.getFile(index);
        if (this.editedFile == null) {
            throw new AssertException("Unexpected condition - asked to edit file that does not exist in model");
        }
        this.listEditor.setBounds(r.x, r.y, r.width, r.height);
        this.listEditor.setVisible(true);
        this.listEditorLabel.setIcon(this.chooser.getModel().getIcon(this.editedFile));
        this.listEditorField.setText(this.editedFile.getName());
        this.listEditorField.requestFocus();
        this.listEditorField.selectAll();
    }

    void cancelListEdit() {
        this.editedFile = null;
        this.remove(this.listEditor);
        this.listEditor.setVisible(false);
        this.listEditorLabel.setIcon(null);
        this.listEditorField.setText("");
        this.repaint();
    }

    void stopListEdit() {
        if (!this.isEditing()) {
            return;
        }
        String invalidFilenameMessage = this.chooser.getInvalidFilenameMessage(this.listEditorField.getText());
        if (invalidFilenameMessage != null) {
            this.chooser.setStatusText("Rename aborted - " + invalidFilenameMessage);
            this.cancelListEdit();
            return;
        }
        File editedFileCopy = this.editedFile;
        int index = this.model.indexOfFile(editedFileCopy);
        if (index < 0) {
            throw new AssertException("Somehow editing file not in our model.");
        }
        File dest = new File(editedFileCopy.getParentFile(), this.listEditorField.getText());
        this.cancelListEdit();
        if (this.chooser.getModel().renameFile(editedFileCopy, dest)) {
            this.chooser.setStatusText("");
            this.model.set(index, dest);
            this.chooser.setSelectedFileAndUpdateDisplay(dest);
        } else {
            this.chooser.setStatusText("Unable to rename " + editedFileCopy);
        }
    }

    private void recomputeListCellDimensions(List<File> files) {
        files = files != null ? files : this.model.getAllFiles();
        Dimension d = this.cellRenderer.computePlainTextListCellDimensions(this, files, 0, 16);
        if (d.width == 0 && this.getParent() != null) {
            if (this.getParent().getParent() instanceof JScrollPane) {
                JScrollPane parent = (JScrollPane)this.getParent().getParent();
                Dimension parentSize = parent.getSize();
                Insets insets = parent.getInsets();
                d.width = parentSize.width - (insets != null ? insets.right + insets.left : 0);
            }
        } else {
            d.width += 30;
        }
        this.setFixedCellWidth(d.width);
        this.setFixedCellHeight(d.height + 5);
    }

    JTextField getListEditorText() {
        return this.listEditorField;
    }
}

