/*
 * Decompiled with CFR 0.152.
 */
package generic.concurrent;

import generic.concurrent.FutureTaskMonitor;
import generic.concurrent.GThreadPool;
import generic.concurrent.ProgressTracker;
import generic.concurrent.QCallback;
import generic.concurrent.QItemListener;
import generic.concurrent.QProgressListener;
import generic.concurrent.QResult;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentQ<I, R> {
    private final Queue<I> queue;
    private final GThreadPool threadPool;
    private final QCallback<I, R> callback;
    private QItemListener<I, R> itemListener;
    private QProgressListener<I> progressListener;
    private Deque<QResult<I, R>> resultList = new LinkedList<QResult<I, R>>();
    private final Set<FutureTaskMonitor<I, R>> taskSet = new HashSet<FutureTaskMonitor<I, R>>();
    private final int maxInProgress;
    private final boolean collectResults;
    private final boolean jobsReportProgress;
    private QMonitorAdapter monitorAdapter;
    private Exception unhandledException;
    private ProgressTracker tracker;
    private ReentrantLock lock = new ReentrantLock(false);

    public ConcurrentQ(String name, QCallback<I, R> callback) {
        this(callback, new LinkedList(), GThreadPool.getPrivateThreadPool(name), null, false, 0, false);
    }

    public ConcurrentQ(QCallback<I, R> callback, Queue<I> queue, GThreadPool threadPool, QItemListener<I, R> listener, boolean collectResults, int maxInProgress, boolean jobsReportProgress) {
        this.callback = callback;
        this.queue = queue;
        this.threadPool = threadPool;
        this.itemListener = listener;
        this.collectResults = collectResults;
        this.jobsReportProgress = jobsReportProgress;
        this.maxInProgress = maxInProgress > 0 ? maxInProgress : threadPool.getMaxThreadCount();
        this.tracker = new ProgressTracker(this.lock);
    }

    public synchronized void addProgressListener(QProgressListener<I> listener) {
        this.progressListener = this.progressListener == null ? listener : new ChainedProgressListener<I>(this.progressListener, listener);
    }

    public synchronized void removeProgressListener(QProgressListener<I> listener) {
        if (this.progressListener == listener) {
            this.progressListener = null;
        } else if (this.progressListener instanceof ChainedProgressListener) {
            this.progressListener = ((ChainedProgressListener)this.progressListener).removeListener(listener);
        }
    }

    public void setMonitor(TaskMonitor monitor, boolean cancelClearsAllItems) {
        if (this.monitorAdapter != null) {
            this.monitorAdapter.dispose();
        }
        if (monitor != null) {
            this.monitorAdapter = new QMonitorAdapter(monitor, cancelClearsAllItems);
        }
    }

    public void add(Collection<I> items) {
        this.lock.lock();
        try {
            this.queue.addAll(items);
            this.tracker.itemsAdded(items.size());
            this.fillOpenProcessingSlots();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(Iterator<I> iterator) {
        this.lock.lock();
        try {
            while (iterator.hasNext()) {
                this.queue.add(iterator.next());
                this.tracker.itemsAdded(1);
                this.fillOpenProcessingSlots();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void offer(Iterator<I> iterator) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (iterator.hasNext()) {
                I next = iterator.next();
                if (!this.queue.offer(next)) {
                    this.tracker.waitForNext();
                    this.queue.offer(next);
                }
                this.tracker.itemsAdded(1);
                this.fillOpenProcessingSlots();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void add(I item) {
        this.lock.lock();
        try {
            this.queue.add(item);
            this.tracker.itemsAdded(1);
            this.fillOpenProcessingSlots();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEmpty() {
        return this.tracker.isDone();
    }

    public Collection<QResult<I, R>> waitForResults() throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            this.tracker.waitUntilDone();
            Deque<QResult<I, R>> returnValue = this.resultList;
            this.resultList = new LinkedList<QResult<I, R>>();
            Deque<QResult<I, R>> deque = returnValue;
            return deque;
        }
        finally {
            this.lock.unlock();
        }
    }

    public QResult<I, R> waitForNextResult() throws InterruptedException {
        if (!this.collectResults) {
            throw new IllegalStateException("Can't wait for next result when not collecting results");
        }
        this.lock.lockInterruptibly();
        try {
            if (this.resultList.isEmpty()) {
                if (this.isEmpty()) {
                    QResult<I, R> qResult = null;
                    return qResult;
                }
                this.tracker.waitForNext();
            }
            QResult<I, R> qResult = this.resultList.pop();
            return qResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void waitUntilDone() throws InterruptedException, Exception {
        this.lock.lockInterruptibly();
        try {
            this.checkException();
            while (!this.isEmpty()) {
                this.tracker.waitForNext();
                this.checkException();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkException() throws Exception {
        if (this.unhandledException != null) {
            this.cancelAllTasks(true);
            throw this.unhandledException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QResult<I, R>> waitForResults(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            this.tracker.waitUntilDone(timeout, unit);
            Deque<QResult<I, R>> returnValue = this.resultList;
            this.resultList = new LinkedList<QResult<I, R>>();
            Deque<QResult<I, R>> deque = returnValue;
            return deque;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<I> cancelAllTasks(boolean interruptRunningTasks) {
        List<I> nonStartedItems;
        ArrayList<FutureTaskMonitor<I, R>> tasksToBeCancelled = new ArrayList<FutureTaskMonitor<I, R>>();
        this.lock.lock();
        try {
            nonStartedItems = this.removeUnscheduledJobs();
            tasksToBeCancelled.addAll(this.taskSet);
        }
        finally {
            this.lock.unlock();
        }
        for (FutureTaskMonitor futureTaskMonitor : tasksToBeCancelled) {
            futureTaskMonitor.cancel(interruptRunningTasks);
        }
        return nonStartedItems;
    }

    public List<I> removeUnscheduledJobs() {
        ArrayList<I> nonStartedItems = new ArrayList<I>();
        this.lock.lock();
        try {
            this.tracker.neverStartedItemsRemoved(this.queue.size());
            nonStartedItems.addAll(this.queue);
            this.queue.clear();
        }
        finally {
            this.lock.unlock();
        }
        return nonStartedItems;
    }

    public void cancelScheduledJobs() {
        ArrayList<FutureTaskMonitor<I, R>> tasksToBeCancelled = new ArrayList<FutureTaskMonitor<I, R>>();
        this.lock.lock();
        try {
            tasksToBeCancelled.addAll(this.taskSet);
        }
        finally {
            this.lock.unlock();
        }
        for (FutureTaskMonitor futureTaskMonitor : tasksToBeCancelled) {
            futureTaskMonitor.cancel(true);
        }
    }

    public void dispose() {
        this.cancelAllTasks(true);
        if (this.threadPool.isPrivate()) {
            this.threadPool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilDone(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            this.tracker.waitUntilDone(timeout, unit);
            boolean bl = this.tracker.isDone();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void fillOpenProcessingSlots() {
        while (!this.queue.isEmpty() && this.getInProgressCount() < (long)this.maxInProgress) {
            I item = this.queue.remove();
            this.tracker.itemStarted();
            CallbackCallable qCall = new CallbackCallable(item);
            FutureTaskMonitor task = new FutureTaskMonitor(this, qCall, item, this.tracker.getNextID());
            qCall.setFutureTask(task);
            this.taskSet.add(task);
            this.notifyTaskStarted(task);
            this.threadPool.submit(task);
        }
    }

    private void notifyTaskStarted(FutureTaskMonitor<I, R> task) {
        QProgressListener<I> listener = this.progressListener;
        if (listener == null) {
            return;
        }
        this.lock.unlock();
        try {
            listener.taskStarted(task.getID(), task.getItem());
        }
        finally {
            this.lock.lock();
        }
    }

    private long getInProgressCount() {
        return this.tracker.getItemsInProgressCount();
    }

    void itemProcessed(FutureTaskMonitor<I, R> task, QResult<I, R> result) {
        if (this.itemListener != null) {
            this.itemListener.itemProcessed(result);
        }
        this.lock.lock();
        try {
            this.taskSet.remove(task);
            if (this.collectResults) {
                this.resultList.add(result);
            }
            this.tracker.InProgressitemCompletedOrCancelled();
            this.fillOpenProcessingSlots();
            if (result.hasError() && this.unhandledException == null) {
                this.unhandledException = result.getError();
            }
        }
        finally {
            this.lock.unlock();
        }
        QProgressListener<I> listener = this.progressListener;
        if (listener != null) {
            listener.taskEnded(task.getID(), task.getItem(), this.tracker.getTotalItemCount(), this.tracker.getCompletedItemCount());
        }
    }

    void progressChanged(long id, I item, long currentProgress) {
        QProgressListener<I> listener = this.progressListener;
        if (listener != null) {
            listener.progressChanged(id, item, currentProgress);
        }
    }

    void maxProgressChanged(long id, I item, long maxProgress) {
        QProgressListener<I> listener = this.progressListener;
        if (listener != null) {
            listener.maxProgressChanged(id, item, maxProgress);
        }
    }

    void progressModeChanged(long id, I item, boolean indeterminate) {
        QProgressListener<I> listener = this.progressListener;
        if (listener != null) {
            listener.progressModeChanged(id, item, indeterminate);
        }
    }

    void progressMessageChanged(long id, I item, String message) {
        QProgressListener<I> listener = this.progressListener;
        if (listener != null) {
            listener.progressMessageChanged(id, item, message);
        }
    }

    private class QMonitorAdapter
    implements QProgressListener<I>,
    CancelledListener {
        private TaskMonitor monitor;
        public final boolean cancelClearsAllJobs;

        QMonitorAdapter(TaskMonitor monitor, boolean cancelClearsAll) {
            this.monitor = monitor;
            this.cancelClearsAllJobs = cancelClearsAll;
            ConcurrentQ.this.addProgressListener(this);
            monitor.addCancelledListener((CancelledListener)this);
        }

        public void cancelled() {
            if (this.cancelClearsAllJobs) {
                ConcurrentQ.this.cancelAllTasks(true);
            } else {
                ConcurrentQ.this.cancelScheduledJobs();
                this.monitor.clearCanceled();
            }
        }

        @Override
        public void progressChanged(long id, I Item, long currentProgress) {
            if (ConcurrentQ.this.jobsReportProgress) {
                this.monitor.setProgress(currentProgress);
            }
        }

        @Override
        public void progressModeChanged(long id, I item, boolean indeterminate) {
            if (ConcurrentQ.this.jobsReportProgress) {
                this.monitor.setIndeterminate(indeterminate);
            }
        }

        @Override
        public void progressMessageChanged(long id, I item, String message) {
            this.monitor.setMessage(message);
        }

        @Override
        public void maxProgressChanged(long id, I item, long maxProgress) {
            if (ConcurrentQ.this.jobsReportProgress) {
                this.monitor.setMaximum(maxProgress);
            }
        }

        @Override
        public void taskStarted(long id, I Item) {
        }

        @Override
        public void taskEnded(long id, I Item, long total, long progress) {
            if (!ConcurrentQ.this.jobsReportProgress) {
                if (total != this.monitor.getMaximum()) {
                    this.monitor.setMaximum(total);
                }
                this.monitor.setProgress(progress);
            }
        }

        public void dispose() {
            ConcurrentQ.this.removeProgressListener(this);
            this.monitor.removeCancelledListener((CancelledListener)this);
            this.monitor = TaskMonitor.DUMMY;
        }
    }

    private static class ChainedProgressListener<I>
    implements QProgressListener<I> {
        private volatile QProgressListener<I> listener1;
        private volatile QProgressListener<I> listener2;

        ChainedProgressListener(QProgressListener<I> listener1, QProgressListener<I> listener2) {
            this.listener1 = listener1;
            this.listener2 = listener2;
        }

        QProgressListener<I> removeListener(QProgressListener<I> listener) {
            if (this.listener1 == listener) {
                return this.listener2;
            }
            if (this.listener2 == listener) {
                return this.listener1;
            }
            if (this.listener1 instanceof ChainedProgressListener) {
                this.listener1 = ((ChainedProgressListener)this.listener1).removeListener(listener);
            }
            if (this.listener2 instanceof ChainedProgressListener) {
                this.listener2 = ((ChainedProgressListener)this.listener2).removeListener(listener);
            }
            return this;
        }

        @Override
        public void progressChanged(long id, I Item, long currentProgress) {
            this.listener1.progressChanged(id, Item, currentProgress);
            this.listener2.progressChanged(id, Item, currentProgress);
        }

        @Override
        public void taskStarted(long id, I Item) {
            this.listener1.taskStarted(id, Item);
            this.listener2.taskStarted(id, Item);
        }

        @Override
        public void taskEnded(long id, I Item, long totalCount, long completedCount) {
            this.listener1.taskEnded(id, Item, totalCount, completedCount);
            this.listener2.taskEnded(id, Item, totalCount, completedCount);
        }

        @Override
        public void progressModeChanged(long id, I item, boolean indeterminate) {
            this.listener1.progressModeChanged(id, item, indeterminate);
            this.listener2.progressModeChanged(id, item, indeterminate);
        }

        @Override
        public void progressMessageChanged(long id, I item, String message) {
            this.listener1.progressMessageChanged(id, item, message);
            this.listener2.progressMessageChanged(id, item, message);
        }

        @Override
        public void maxProgressChanged(long id, I item, long maxProgress) {
            this.listener1.maxProgressChanged(id, item, maxProgress);
            this.listener2.maxProgressChanged(id, item, maxProgress);
        }
    }

    private class CallbackCallable
    implements Callable<R> {
        private I item;
        private FutureTaskMonitor<I, R> future;

        CallbackCallable(I item) {
            this.item = item;
        }

        @Override
        public R call() throws Exception {
            return ConcurrentQ.this.callback.process(this.item, this.future);
        }

        void setFutureTask(FutureTaskMonitor<I, R> future) {
            this.future = future;
        }
    }
}

