/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.framework.Application;
import ghidra.framework.GenericRunInfo;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class OpenArchiveAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public OpenArchiveAction(DataTypeManagerPlugin plugin) {
        super("Open File Data Type Archive", plugin.getName());
        this.plugin = plugin;
        this.setMenuBarData(new MenuData(new String[]{"Open File Archive..."}, "Archive"));
        this.setDescription("Opens a data type archive in this data type manager.");
        this.setEnabled(true);
    }

    public void actionPerformed(ActionContext context) {
        DataTypesProvider provider = this.plugin.getProvider();
        DataTypeArchiveGTree tree = provider.getGTree();
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)((Object)tree));
        File archiveDirectory = this.getArchiveDirectory();
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(new String[]{"gdt"}, "Ghidra Data Type Files"));
        fileChooser.setCurrentDirectory(archiveDirectory);
        fileChooser.setApproveButtonText("Open DataType Archive File");
        fileChooser.setApproveButtonToolTipText("Open DataType Archive File");
        DataTypeManagerHandler manager = this.plugin.getDataTypeManagerHandler();
        File file = fileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.getName().endsWith("gdt")) {
            file = new File(file.getParent(), file.getName() + ".gdt");
        }
        File lastOpenedDir = file.getParentFile();
        Preferences.setProperty((String)"LastOpenedArchiveDirectory", (String)lastOpenedDir.getAbsolutePath());
        try {
            Archive archive = manager.openArchive(file, false, true);
            GTreeNode node = this.getNodeForArchive(tree, archive);
            if (node != null) {
                tree.setSelectedNode(node);
            }
        }
        catch (Throwable t) {
            DataTypeManagerHandler.handleArchiveFileException(this.plugin, new ResourceFile(file), t);
        }
    }

    private GTreeNode getNodeForArchive(GTree tree, Archive archive) {
        GTreeRootNode rootNode = tree.getRootNode();
        List allChildren = rootNode.getAllChildren();
        for (GTreeNode node : allChildren) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            if (archiveNode.getArchive() != archive) continue;
            return archiveNode;
        }
        return null;
    }

    private File getArchiveDirectory() {
        String lastOpenedDirPath = Preferences.getProperty((String)"LastOpenedArchiveDirectory", null, (boolean)true);
        if (lastOpenedDirPath != null) {
            return new File(lastOpenedDirPath);
        }
        String archiveDirPath = this.getTypeInfoDirPath();
        if (archiveDirPath == null) {
            archiveDirPath = GenericRunInfo.getProjectsDirPath();
        }
        return new File(archiveDirPath);
    }

    private String getTypeInfoDirPath() {
        try {
            File dir = Application.getModuleDataSubDirectory((String)"Base", (String)"typeinfo").getFile(false);
            if (dir == null) {
                return null;
            }
            return dir.getAbsolutePath();
        }
        catch (IOException e) {
            Msg.debug(null, (Object)"typeinfo directory not found");
            return null;
        }
    }
}

