/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveManagerListener;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.InvalidFileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.InvalidArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProgramArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class ArchiveRootNode
extends GTreeLazyNode
implements GTreeRootNode,
DataTypeTreeNode {
    private static final String NAME = "Data Types";
    private GTree tree;
    private final DataTypeManagerHandler archiveManager;
    private RootNodeListener archiveListener;

    ArchiveRootNode(DataTypeManagerHandler archiveManager) {
        this.archiveManager = archiveManager;
        this.archiveListener = new RootNodeListener();
        archiveManager.addArchiveManagerListener(this.archiveListener);
    }

    public DataTypeManagerHandler getArchiveHandler() {
        return this.archiveManager;
    }

    public void dispose() {
        this.archiveManager.removeArchiveManagerListener(this.archiveListener);
        super.dispose();
    }

    public Icon getIcon(boolean expanded) {
        return DataTypeUtils.getRootIcon(expanded);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getToolTip() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    private static final GTreeNode createArchiveNode(Archive archive) {
        if (archive instanceof FileArchive) {
            return new FileArchiveNode((FileArchive)archive);
        }
        if (archive instanceof ProjectArchive) {
            return new ProjectArchiveNode((ProjectArchive)archive);
        }
        if (archive instanceof InvalidFileArchive) {
            return new InvalidArchiveNode((InvalidFileArchive)archive);
        }
        if (archive instanceof ProgramArchive) {
            return new ProgramArchiveNode((ProgramArchive)archive);
        }
        if (archive instanceof BuiltInArchive) {
            return new BuiltInArchiveNode((BuiltInArchive)archive);
        }
        return null;
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        throw new AssertException("Cannot call setNodeCut() on ArchiveRootNode.");
    }

    @Override
    public ArchiveNode getArchiveNode() {
        return null;
    }

    @Override
    public boolean isSystemNode() {
        return true;
    }

    public CategoryNode findCategoryNode(Category category) {
        for (GTreeNode node : this.getAllChildren()) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            CategoryNode categoryNode = archiveNode.findCategoryNode(category);
            if (categoryNode == null) continue;
            return categoryNode;
        }
        return null;
    }

    public ArchiveNode getNodeForManager(DataTypeManager dtm) {
        for (GTreeNode node : this.getAllChildren()) {
            ArchiveNode archiveNode = (ArchiveNode)node;
            Archive archive = archiveNode.getArchive();
            DataTypeManager manager = archive.getDataTypeManager();
            if (!manager.equals(dtm)) continue;
            return archiveNode;
        }
        return null;
    }

    public List<GTreeNode> generateChildren() {
        ArrayList<GTreeNode> children = new ArrayList<GTreeNode>();
        Iterator<Archive> iterator = this.archiveManager.getAllArchives().iterator();
        while (iterator.hasNext()) {
            children.add(ArchiveRootNode.createArchiveNode(iterator.next()));
        }
        Collections.sort(children);
        return children;
    }

    private ArchiveNode getArchiveNode(Archive archive) {
        List allChildrenList = this.getAllChildren();
        for (GTreeNode node : allChildrenList) {
            if (!(node instanceof ArchiveNode)) continue;
            ArchiveNode archiveNode = (ArchiveNode)node;
            if (archiveNode.archive != archive) continue;
            return archiveNode;
        }
        return null;
    }

    public GTree getGTree() {
        return this.tree;
    }

    public void setGTree(GTree tree) {
        this.tree = tree;
    }

    class RootNodeListener
    implements ArchiveManagerListener {
        RootNodeListener() {
        }

        @Override
        public void archiveClosed(Archive archive) {
            if (!ArchiveRootNode.this.isChildrenLoadedOrInProgress()) {
                return;
            }
            List allChildrenList = ArchiveRootNode.this.getAllChildren();
            for (GTreeNode node : allChildrenList) {
                ArchiveNode archiveNode = (ArchiveNode)node;
                if (archive != archiveNode.getArchive()) continue;
                ArchiveRootNode.this.removeNode((GTreeNode)archiveNode);
                archiveNode.dispose();
                return;
            }
        }

        @Override
        public void archiveOpened(Archive archive) {
            if (ArchiveRootNode.this.isChildrenLoadedOrInProgress()) {
                GTreeNode node = ArchiveRootNode.createArchiveNode(archive);
                List allChildrenList = ArchiveRootNode.this.getAllChildren();
                int index = Collections.binarySearch(allChildrenList, node);
                if (index < 0) {
                    index = -index - 1;
                }
                ArchiveRootNode.this.addNode(index, node);
                ArchiveRootNode.this.tree.setFilterText(ArchiveRootNode.this.tree.getFilterText());
            }
        }

        @Override
        public void archiveDataTypeManagerChanged(Archive archive) {
            ArchiveNode archiveNode = ArchiveRootNode.this.getArchiveNode(archive);
            if (archiveNode != null) {
                archiveNode.dataTypeManagerChanged();
            }
        }

        @Override
        public void archiveStateChanged(Archive archive) {
            ArchiveNode archiveNode = ArchiveRootNode.this.getArchiveNode(archive);
            if (archiveNode != null) {
                archiveNode.archiveStateChanged();
            }
        }
    }
}

