/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.DockingUtils;
import docking.action.DockingAction;
import docking.actions.KeyBindingUtils;
import docking.dnd.DropTgtAdapter;
import docking.widgets.JTreeMouseListenerDelegate;
import ghidra.app.plugin.core.programtree.DnDMoveManager;
import ghidra.app.plugin.core.programtree.DragNDropTree;
import ghidra.app.plugin.core.programtree.GroupTransferable;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreeAction;
import ghidra.app.plugin.core.programtree.ProgramTreeActionManager;
import ghidra.app.plugin.core.programtree.ProgramTreeModelListener;
import ghidra.app.plugin.core.programtree.ProgramTreePlugin;
import ghidra.app.plugin.core.programtree.TreeListener;
import ghidra.app.plugin.core.programtree.TreeTransferable;
import ghidra.app.util.SelectionTransferData;
import ghidra.app.util.SelectionTransferable;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DuplicateGroupException;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.GroupPath;
import ghidra.util.Msg;
import ghidra.util.datastruct.StringKeyIndexer;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.exception.UsrException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ProgramDnDTree
extends DragNDropTree {
    private Program program;
    private Listing listing;
    private ArrayList<ProgramNode> nodeList;
    private ArrayList<TreePath> viewList;
    private StringKeyIndexer nameIndexer;
    private ProgramTreeActionManager actionManager;
    private DnDMoveManager dragDropManager;
    private TreeListener treeListener;
    private JTreeMouseListenerDelegate mouseListenerDelegate;
    private Plugin plugin;
    private String treeName;
    private NodeComparator nodeComparator;
    private static final GroupPath[] EMPTY_GROUP_SELECTION = new GroupPath[0];
    private Object versionTag;

    public ProgramDnDTree(String treeName, DefaultTreeModel model, ProgramTreePlugin plugin) {
        super(model);
        this.treeName = treeName;
        this.plugin = plugin;
        this.actionManager = plugin.getActionManager();
        this.initialize();
        this.createRootNode(null);
        this.nodeComparator = new NodeComparator();
        this.mouseListenerDelegate = new JTreeMouseListenerDelegate((JTree)this);
        this.initializeKeyEvents();
    }

    private void initializeKeyEvents() {
        KeyBindingUtils.clearKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(86, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this, (KeyStroke)KeyStroke.getKeyStroke(88, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (this.mouseListenerDelegate == null) {
            super.addMouseListener(l);
            return;
        }
        this.mouseListenerDelegate.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        if (this.mouseListenerDelegate == null) {
            super.removeMouseListener(l);
            return;
        }
        this.mouseListenerDelegate.removeMouseListener(l);
    }

    @Override
    public synchronized MouseListener[] getMouseListeners() {
        if (this.mouseListenerDelegate == null) {
            return super.getMouseListeners();
        }
        return this.mouseListenerDelegate.getMouseListeners();
    }

    @Override
    public void fireTreeExpanded(TreePath path) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (!node.wasVisited()) {
            this.visitNode(node);
            this.buildNodeList();
        }
        super.fireTreeExpanded(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDropOk(DropTargetDragEvent e) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            if (!super.isDropOk(e)) {
                return false;
            }
            if (this.draggedNodes == null) {
                return true;
            }
            Point p = e.getLocation();
            ProgramNode destNode = this.getTreeNode(p);
            this.relativeMousePos = this.comparePointerLocation(p, destNode);
            return this.dragDropManager.isDropSiteOk(destNode, this.draggedNodes, e.getDropAction(), this.relativeMousePos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object data, DropTargetDropEvent e, DataFlavor chosen) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            if (this.destinationNode == null) {
                return;
            }
            try {
                int dropAction = 1;
                if (e != null) {
                    dropAction = e.getDropAction();
                }
                this.processDropRequest(this.destinationNode, data, chosen, dropAction);
                if (dropAction == 1) {
                    this.draggedNodes = null;
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof UsrException)) {
                    Msg.error((Object)this, (Object)("Unexpected Exception: " + ex.getMessage()), (Throwable)ex);
                }
                this.draggedNodes = null;
                String msg = ex.getMessage();
                if (msg == null) {
                    msg = ex.toString();
                }
                if (ex instanceof UsrException) {
                    Msg.showError((Object)this, (Component)this, (String)"Error in Drop Operation", (Object)msg);
                }
                Msg.showError((Object)this, (Component)this, (String)"Error in Drop Operation", (Object)msg, (Throwable)ex);
            }
        }
    }

    @Override
    public void move() {
        this.draggedNodes = null;
    }

    void setProgram(Program p) {
        if (p == this.program) {
            return;
        }
        this.program = p;
        this.disposeOfNodes();
        this.root.removeAllChildren();
        this.nodeList.clear();
        this.listing = null;
        if (this.transferable != null) {
            this.transferable.clearTransferData();
        }
        if (this.program != null) {
            this.listing = this.program.getListing();
            ProgramModule rm = this.listing.getRootModule(this.treeName);
            if (rm != null) {
                ProgramModule oldRootModule = this.root.getModule();
                if (oldRootModule == null || !oldRootModule.equals(rm)) {
                    this.createRootNode(this.program);
                }
                this.layoutProgram();
            } else {
                this.createRootNode(null);
            }
        } else {
            this.createRootNode(null);
        }
    }

    public Program getProgram() {
        return this.program;
    }

    @Override
    protected DataFlavor[] getAcceptableDataFlavors() {
        return ProgramDnDTree.getDataFlavors();
    }

    static DataFlavor[] getDataFlavors() {
        return new DataFlavor[]{TreeTransferable.localTreeNodeFlavor, GroupTransferable.localGroupFlavor, DataFlavor.stringFlavor, SelectionTransferable.localProgramSelectionFlavor};
    }

    @Override
    protected boolean isDropSiteOk(ProgramNode node, DropTargetDragEvent e) {
        int dropAction = e.getDropAction();
        DataFlavor chosen = DropTgtAdapter.getFirstMatchingFlavor((DropTargetDragEvent)e, (DataFlavor[])this.acceptableFlavors);
        if (chosen.equals(GroupTransferable.localGroupFlavor)) {
            if (node.isFragment() && dropAction != 2) {
                return false;
            }
        } else {
            if (chosen.equals(SelectionTransferable.localProgramSelectionFlavor)) {
                if (node.isFragment() && dropAction != 2 || node.isModule() && dropAction != 2) {
                    return false;
                }
                try {
                    Object data = e.getTransferable().getTransferData(SelectionTransferable.localProgramSelectionFlavor);
                    SelectionTransferData transferData = (SelectionTransferData)data;
                    return this.program.getDomainFile().getPathname().equals(transferData.getProgramPath());
                }
                catch (UnsupportedFlavorException e1) {
                    return false;
                }
                catch (IOException e1) {
                    return false;
                }
            }
            if (chosen.equals(TreeTransferable.localTreeNodeFlavor)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getToolTipText(ProgramNode node) {
        if (!node.isFragment()) {
            return null;
        }
        ProgramFragment f = node.getFragment();
        if (f.getNumAddresses() == 0L) {
            return "[ Empty ]";
        }
        AddressRangeIterator iter = f.getAddressRanges();
        StringBuffer sb = new StringBuffer();
        int count = 0;
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            sb.append(range.toString());
            if (iter.hasNext()) {
                sb.append(" ");
            }
            if (++count <= 4) continue;
            sb.append("...");
            break;
        }
        return sb.toString();
    }

    void reload() {
        Program p = this.program;
        this.program = null;
        this.listing = p.getListing();
        this.viewList.clear();
        this.createRootNode(p);
        this.setProgram(p);
    }

    Object getVersionTag() {
        return this.versionTag;
    }

    void setBusyCursor(boolean busy) {
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        Rectangle r = this.getBounds();
        this.invalidateTreeParent();
        this.paintImmediately(r);
    }

    void addTreeListener(TreeListener l) {
        this.treeListener = l;
    }

    void removeTreeListener() {
        this.treeListener = null;
    }

    void clearDragData() {
        this.draggedNodes = null;
    }

    ArrayList<TreePath> getViewList() {
        return this.viewList;
    }

    ArrayList<ProgramNode> getNodeList() {
        return this.nodeList;
    }

    StringKeyIndexer getNameIndexer() {
        return this.nameIndexer;
    }

    void removeFromView(TreePath path) {
        this.viewList.remove(path);
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        node.setInView(false);
        if (node == this.root || node != this.root && node.getParent() != null) {
            this.reloadNode(node);
        }
    }

    void addToView(TreePath path) {
        if (path == null) {
            return;
        }
        this.addToView(path, this.viewList.size());
    }

    void addToView(TreePath path, int index) {
        ProgramNode node = (ProgramNode)path.getLastPathComponent();
        if (!this.viewList.contains(path) && !this.hasAncestorsInView(node)) {
            this.viewList.add(index, path);
            node.setInView(true);
        }
        if (!this.isVisible(path)) {
            for (ProgramNode parent = (ProgramNode)node.getParent(); parent != null; parent = (ProgramNode)parent.getParent()) {
                if (!this.isVisible(parent.getTreePath())) continue;
                this.reloadNode(parent);
                break;
            }
        } else {
            this.reloadNode(node);
        }
    }

    boolean hasAncestorsInView(ProgramNode node) {
        TreePath path = node.getTreePath();
        for (int i = 0; i < this.viewList.size(); ++i) {
            TreePath viewPath = this.viewList.get(i);
            if (!viewPath.isDescendant(path) || viewPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    int startTransaction(String operation) {
        return this.program.startTransaction(operation);
    }

    void endTransaction(int transactionID, boolean commit) {
        this.program.endTransaction(transactionID, commit);
    }

    PluginTool getTool() {
        return this.plugin.getTool();
    }

    void addGroupViewPath(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            this.addToView(path);
        }
    }

    void setViewPaths(TreePath[] paths) {
        int size = this.viewList.size();
        for (int i = 0; i < size; ++i) {
            this.removeFromView(this.viewList.get(0));
        }
        Arrays.sort(paths, this.nodeComparator);
        for (TreePath path : paths) {
            if (path == null) continue;
            this.addToView(path);
        }
        this.fireTreeViewChanged();
    }

    void setGroupViewPaths(GroupPath[] gp) {
        ArrayList<TreePath> list = new ArrayList<TreePath>(3);
        for (GroupPath element : gp) {
            TreePath p = this.getTreePathFromGroup(element);
            if (p == null) continue;
            list.add(p);
        }
        if (list.size() == 0 || this.viewList.containsAll(list) && this.viewList.size() == list.size()) {
            return;
        }
        TreePath[] paths = new TreePath[list.size()];
        this.setViewPaths(list.toArray(paths));
    }

    void setGroupSelection(GroupPath[] groupPaths) {
        ArrayList<TreePath> list = new ArrayList<TreePath>(groupPaths.length);
        for (GroupPath groupPath : groupPaths) {
            TreePath p = this.getTreePathFromGroup(groupPath);
            if (p == null) continue;
            list.add(p);
        }
        TreePath[] paths = new TreePath[list.size()];
        this.setSelectionPaths(list.toArray(paths));
        if (paths.length > 0) {
            this.scrollPathToVisible(paths[0]);
        }
    }

    void expand(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            this.expandPath(path);
        }
    }

    void expandAll(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            this.expandNode((ProgramNode)path.getLastPathComponent());
        }
    }

    boolean isExpanded(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            return this.isExpanded(path);
        }
        return false;
    }

    void fireTreeViewChanged() {
        if (this.treeListener != null) {
            this.treeListener.treeViewChanged(new ChangeEvent(this));
        }
    }

    void collapse(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            this.collapsePath(path);
        }
    }

    void collapseAll(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            this.collapseNode((ProgramNode)path.getLastPathComponent());
        }
    }

    void makeVisible(GroupPath groupPath) {
        TreePath path = this.getTreePathFromGroup(groupPath);
        if (path != null) {
            this.makeVisible(path);
        }
    }

    Enumeration<TreePath> getExpandedDescendants(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            return this.getExpandedDescendants(path);
        }
        return null;
    }

    void setHasFocus(boolean state) {
        if (state) {
            this.actionManager.setProgramTreeView(this.treeName, this);
        }
    }

    boolean addActionToPopup(DockingAction action) {
        if (!(action instanceof ProgramTreeAction)) {
            return true;
        }
        ProgramTreeAction a = (ProgramTreeAction)action;
        int selectionCount = this.getSelectionCount();
        if (a.getSelectionType() == 0) {
            if (selectionCount == 1) {
                return true;
            }
            return selectionCount == 0;
        }
        return selectionCount > 0;
    }

    String getNewFolderName() {
        return this.getNewName("New Folder");
    }

    String getNewFragmentName() {
        return this.getNewName("New Fragment");
    }

    DnDMoveManager getDnDMoveManager() {
        return this.dragDropManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildNodeList() {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            this.nodeList.clear();
            Enumeration<TreeNode> nodes = this.root.preorderEnumeration();
            while (nodes.hasMoreElements()) {
                this.nodeList.add((ProgramNode)nodes.nextElement());
            }
        }
    }

    ArrayList<ProgramNode> getSortedSelection() {
        ArrayList<ProgramNode> list = new ArrayList<ProgramNode>();
        Enumeration<TreeNode> it = this.root.postorderEnumeration();
        while (it.hasMoreElements()) {
            ProgramNode node = (ProgramNode)it.nextElement();
            if (!this.isPathSelected(node.getTreePath())) continue;
            list.add(node);
        }
        return list;
    }

    void expandNode(ProgramNode node) {
        this.expandPath(node.getTreePath());
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.equals(node) || child.isLeaf()) continue;
            this.expandNode(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void groupRemoved(ProgramNode node, String parentModuleName, boolean updateViewList) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            ProgramNode[] nodes;
            ProgramNode parent = (ProgramNode)node.getParent();
            if (parent == null) {
                return;
            }
            if (parentModuleName.equals(this.root.getModule().getName())) {
                parentModuleName = this.root.getName();
            }
            if ((nodes = this.findNodes(node.getName())).length == 0) {
                return;
            }
            for (ProgramNode child : nodes) {
                parent = (ProgramNode)child.getParent();
                if (parent == null) {
                    throw new RuntimeException("Parent in node " + node + " is null!");
                }
                if (!parentModuleName.equals(parent.getName())) continue;
                TreePath childPath = child.getTreePath();
                this.treeModel.removeNodeFromParent(child);
                child.removeAllChildren();
                child.removeFromParent();
                if (!updateViewList) continue;
                this.removeDescendantsFromView(childPath);
            }
            String name = node.getName();
            ProgramModule m = this.listing.getModule(this.treeName, name);
            ProgramFragment f = this.listing.getFragment(this.treeName, name);
            if (m == null && f == null) {
                this.nameIndexer.remove(name);
            }
            this.buildNodeList();
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeGroup(ProgramNode node, StringBuffer sb) {
        boolean changesMade = false;
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            ProgramNode parent = (ProgramNode)node.getParent();
            if (parent == null) {
                return false;
            }
            ProgramModule parentModule = node.getParentModule();
            try {
                if (parentModule.removeChild(node.getName())) {
                    changesMade = true;
                }
            }
            catch (NotEmptyException e) {
                sb.append("\n" + node.getName() + " from " + parentModule.getName() + ": Not Empty");
            }
        }
        return changesMade;
    }

    ProgramNode insertGroup(ProgramNode parent, Group group, int index) {
        if (parent == null) {
            parent = this.root;
        }
        ProgramNode child = new ProgramNode(this.program, group);
        this.treeModel.insertNodeInto(child, parent, index);
        child.setParentModule(parent.getModule());
        int keyIndex = this.nameIndexer.get(group.getName());
        if (keyIndex < 0) {
            this.nameIndexer.put(group.getName());
        }
        return child;
    }

    void groupAdded(Group group) {
        this.groupAdded(group, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void groupAdded(Group group, boolean reparented) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            String[] parentNames = group.getParentNames();
            boolean treeChanged = false;
            for (String parentName : parentNames) {
                ProgramNode[] nodes;
                ProgramModule parent = this.listing.getModule(this.treeName, parentName);
                for (ProgramNode node : nodes = this.findNodes((Group)parent)) {
                    boolean alreadyAdded = false;
                    int nchild = node.getChildCount();
                    for (int k = 0; k < nchild; ++k) {
                        ProgramNode child = (ProgramNode)node.getChildAt(k);
                        Group childGroup = child.getGroup();
                        if (childGroup == null || !childGroup.equals(group)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded || !node.wasVisited()) continue;
                    int index = node.getChildCount();
                    if (reparented) {
                        index = this.getChildIndex(node, group);
                    }
                    this.insertGroup(node, group, index);
                    treeChanged = true;
                }
            }
            if (treeChanged) {
                this.buildNodeList();
                this.fireTreeViewChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reorder(Group group, ProgramModule parentModule, int index) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            ArrayList<TreePath> list = new ArrayList<TreePath>();
            ProgramNode[] nodes = this.findNodes(group);
            Group[] groups = parentModule.getChildren();
            for (ProgramNode node : nodes) {
                ProgramNode child;
                Enumeration<TreePath> it;
                ProgramNode parent = (ProgramNode)node.getParent();
                if (!parent.getModule().equals(parentModule)) continue;
                TreePath path = parent.getTreePath();
                if (this.isExpanded(path)) {
                    list.add(path);
                }
                if ((it = this.getExpandedDescendants(path)) != null) {
                    while (it.hasMoreElements()) {
                        list.add(it.nextElement());
                    }
                }
                if ((child = (ProgramNode)parent.getChildAt(index)).getName().equals(groups[index].getName())) continue;
                int tempIndex = index;
                if (index == parent.getChildCount()) {
                    tempIndex = index - 1;
                }
                parent.insert(node, tempIndex);
                this.treeModel.reload(parent);
            }
            for (int i = 0; i < list.size(); ++i) {
                TreePath p = (TreePath)list.get(i);
                this.expandPath(p);
            }
        }
    }

    void reorder(Group group, ProgramModule parentModule) {
        Group[] children = parentModule.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!children[i].equals(group)) continue;
            this.reorder(group, parentModule, i);
            return;
        }
    }

    void rename() {
        this.setEditable(true);
        TreePath path = this.getSelectionPath();
        if (path != null) {
            this.startEditingAtPath(path);
        }
    }

    void mergeGroup(Group sourceGroup, ProgramFragment destFragment) throws NotFoundException, NotEmptyException {
        if (sourceGroup instanceof ProgramFragment) {
            this.mergeFragments((ProgramFragment)sourceGroup, destFragment);
        } else {
            this.flattenModule((ProgramModule)sourceGroup, destFragment);
        }
    }

    ProgramNode getChild(ProgramNode parentNode, String name) {
        int nchild = parentNode.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)parentNode.getChildAt(i);
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    void matchExpansionState(ProgramNode sourceNode, ProgramNode destNode) {
        if (!sourceNode.getAllowsChildren()) {
            return;
        }
        if (!destNode.wasVisited()) {
            this.visitNode(destNode);
        }
        if (this.isExpanded(sourceNode.getTreePath())) {
            this.expandPath(destNode.getTreePath());
        }
        int nchild = sourceNode.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode sNode = (ProgramNode)sourceNode.getChildAt(i);
            if (!sNode.getAllowsChildren()) continue;
            ProgramNode dNode = (ProgramNode)destNode.getChildAt(i);
            if (this.isExpanded(sNode.getTreePath())) {
                this.expandPath(dNode.getTreePath());
            }
            this.matchExpansionState(sNode, dNode);
        }
    }

    void disableActions() {
        this.actionManager.disableActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProgramNode prepareSelectionForPopup(MouseEvent event) {
        ProgramNode programNode = this.root;
        synchronized (programNode) {
            if (event != null && event.getSource() != this) {
                return null;
            }
            Point popupPoint = event != null ? event.getPoint() : null;
            int nselected = this.getSelectionCount();
            TreePath selPath = null;
            selPath = popupPoint != null ? this.getPathForLocation((int)popupPoint.getX(), (int)popupPoint.getY()) : this.getSelectionPath();
            ProgramNode node = null;
            if (selPath != null) {
                node = (ProgramNode)selPath.getLastPathComponent();
            }
            if (nselected <= 1) {
                if (selPath != null && !this.isPathSelected(selPath)) {
                    this.setSelectionPath(selPath);
                    this.actionManager.adjustSingleActions(node);
                    return node;
                }
                if (selPath != null) {
                    this.actionManager.adjustSingleActions(node);
                    return node;
                }
                this.actionManager.disableActions();
                return null;
            }
            if (selPath != null && this.isPathSelected(selPath) || selPath == null) {
                this.actionManager.adjustMultiActions();
                return node;
            }
            this.setSelectionPath(selPath);
            this.actionManager.adjustSingleActions(node);
            return node;
        }
    }

    void reloadNode(ProgramNode node) {
        ArrayList<TreePath> list = this.getExpandedPaths(node);
        TreePath[] paths = this.getSelectionPaths();
        this.treeModel.reload(node);
        this.expandPaths(list);
        this.addSelectionPaths(paths);
    }

    ProgramNode[] findNodes(String groupName) {
        ArrayList<ProgramNode> list = new ArrayList<ProgramNode>();
        for (int i = 0; i < this.nodeList.size(); ++i) {
            ProgramNode node = this.nodeList.get(i);
            if (!node.getName().equals(groupName)) continue;
            list.add(node);
        }
        ProgramNode[] nodes = new ProgramNode[list.size()];
        return list.toArray(nodes);
    }

    void addGroupSelectionPath(GroupPath gp) {
        TreePath path = this.getTreePathFromGroup(gp);
        if (path != null) {
            this.addSelectionPath(path);
        }
    }

    GroupPath[] getSelectedGroupPaths() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || this.program == null) {
            return EMPTY_GROUP_SELECTION;
        }
        GroupPath[] groupPaths = new GroupPath[paths.length];
        for (int i = 0; i < groupPaths.length; ++i) {
            ProgramNode node = (ProgramNode)paths[i].getLastPathComponent();
            groupPaths[i] = node.getGroupPath();
        }
        return groupPaths;
    }

    void updateGroupPath(ProgramNode node) {
        this.setGroupPath(node);
        this.reloadNode(node);
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            this.updateGroupPath(child);
        }
    }

    void setGroupPath(ProgramNode node) {
        TreeNode[] pnodes = node.getPath();
        String[] names = new String[pnodes.length];
        for (int i = 0; i < pnodes.length; ++i) {
            ProgramNode n = (ProgramNode)pnodes[i];
            names[i] = n.toString();
        }
        node.setGroupPath(new GroupPath(names));
    }

    void visitNode(ProgramNode node) {
        Group[] groups;
        node.visit();
        int nChildNodes = node.getChildCount();
        ProgramModule m = node.getModule();
        for (Group group : groups = m.getChildren()) {
            if (nChildNodes != 0 && this.childGroupAdded(node, group)) continue;
            this.insertGroup(node, group, node.getChildCount());
        }
    }

    void goTo(Address address) {
        if (this.treeListener != null) {
            this.treeListener.goTo(address);
        }
    }

    String getTreeName() {
        return this.treeName;
    }

    void setTreeName(String treeName) {
        this.treeName = treeName;
    }

    Comparator<TreePath> getNodeComparator() {
        return this.nodeComparator;
    }

    private void removeDescendantsFromView(TreePath parentPath) {
        this.removeFromView(parentPath);
        ProgramNode node = (ProgramNode)parentPath.getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.getAllowsChildren()) {
                this.removeDescendantsFromView(child.getTreePath());
                continue;
            }
            this.removeFromView(child.getTreePath());
        }
    }

    public void expandPaths(List<TreePath> list) {
        for (int i = 0; i < list.size(); ++i) {
            TreePath path = list.get(i);
            this.expandPath(path);
        }
    }

    private void initialize() {
        this.dragDropManager = new DnDMoveManager(this);
        this.setRowHeight(18);
        this.nodeList = new ArrayList();
        this.viewList = new ArrayList();
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(new ProgramTreeModelListener(this));
        }
        this.setEditable(false);
        this.nameIndexer = new StringKeyIndexer();
    }

    private void layoutProgram() {
        ProgramModule rootModule = this.root.getModule();
        this.root.visit();
        Group[] children = rootModule.getChildren();
        this.root.setGroupPath(new GroupPath(new String[]{rootModule.getName()}));
        for (Group element : children) {
            this.insertGroup(this.root, element, this.root.getChildCount());
        }
        this.root.setTreePath(this.getPathForRow(0));
        this.buildNodeList();
    }

    private ProgramNode[] findNodes(Group g) {
        ArrayList<ProgramNode> list = new ArrayList<ProgramNode>();
        for (int i = 0; i < this.nodeList.size(); ++i) {
            ProgramNode node = this.nodeList.get(i);
            Group group = node.getGroup();
            if (group == null || !group.equals(g)) continue;
            list.add(node);
        }
        ProgramNode[] nodes = new ProgramNode[list.size()];
        return list.toArray(nodes);
    }

    private TreePath findTreePath(GroupPath groupPath) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            ProgramNode node = this.nodeList.get(i);
            GroupPath p = node.getGroupPath();
            if (!p.equals((Object)groupPath)) continue;
            return node.getTreePath();
        }
        return null;
    }

    void collapseNode(ProgramNode node) {
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (child.equals(node) || child.isLeaf()) continue;
            this.collapseNode(child);
        }
        this.collapsePath(node.getTreePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addCodeUnits(ProgramNode destNode, AddressSetView view) {
        if (destNode == null) {
            return;
        }
        Listing currentListing = this.program.getListing();
        Address start = view.getMinAddress();
        ProgramFragment sourceFrag = currentListing.getFragment(this.treeName, start);
        Data data = currentListing.getDefinedDataContaining(start);
        if (data != null && !view.getMinAddress().equals((Object)data.getMinAddress())) {
            view = new AddressSet(data.getMinAddress(), data.getMaxAddress());
        }
        int transactionID = this.startTransaction("Move Code Units");
        boolean addEdit = false;
        try {
            if (destNode.isFragment()) {
                try {
                    this.moveRanges(destNode.getFragment(), view);
                    addEdit = true;
                }
                catch (NotFoundException e) {
                    Msg.showInfo(this.getClass(), (Component)this, (String)"Move Code Units Failed", (Object)e.getMessage());
                    this.endTransaction(transactionID, addEdit);
                    return;
                }
            } else {
                addEdit = this.createFragmentFromView(destNode, view);
            }
            if (addEdit && sourceFrag.isEmpty()) {
                try {
                    this.removeEmptyFragment(sourceFrag);
                }
                catch (NotEmptyException notEmptyException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.endTransaction(transactionID, addEdit);
        }
        if (addEdit) {
            this.fireTreeViewChanged();
        }
    }

    private void removeEmptyFragment(ProgramFragment frag) throws NotEmptyException {
        ProgramModule[] parents;
        String name = frag.getName();
        for (ProgramModule parent2 : parents = frag.getParents()) {
            parent2.removeChild(name);
        }
    }

    private boolean createFragmentFromView(ProgramNode destNode, AddressSetView view) {
        String name = this.generateFragmentName(view.getMinAddress());
        ProgramFragment f = this.listing.getFragment(this.treeName, name);
        if (f == null) {
            ProgramModule m = this.listing.getModule(this.treeName, name);
            if (m != null) {
                name = this.getNewFragmentName();
            }
        } else {
            name = this.getNewFragmentName();
        }
        ProgramModule destModule = destNode.getModule();
        ProgramFragment newFrag = null;
        try {
            newFrag = destModule.createFragment(name);
            this.moveRanges(newFrag, view);
            return true;
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (NotFoundException e) {
            try {
                destModule.removeChild(name);
                Msg.showError((Object)this, (Component)this, (String)"Move Code Units Failed", (Object)e.getMessage());
            }
            catch (NotEmptyException notEmptyException) {
                // empty catch block
            }
        }
        return false;
    }

    void processDropRequest(ProgramNode targetNode, Object data, DataFlavor chosen, int dropAction) throws NotFoundException, CircularDependencyException, DuplicateGroupException {
        if (chosen.equals(SelectionTransferable.localProgramSelectionFlavor)) {
            SelectionTransferData transferData = (SelectionTransferData)data;
            AddressSetView view = transferData.getAddressSet();
            if (view.getNumAddressRanges() == 0) {
                throw new RuntimeException("Nothing to drop!");
            }
            this.addCodeUnits(targetNode, view);
            return;
        }
        if (chosen.equals(GroupTransferable.localGroupFlavor)) {
            return;
        }
        if (chosen.equals(DataFlavor.stringFlavor)) {
            return;
        }
        List list = (List)data;
        if (list.size() == 0) {
            throw new RuntimeException("Nothing to drop!");
        }
        ProgramNode[] dropNodes = list.toArray(new ProgramNode[list.size()]);
        this.dragDropManager.add(targetNode, dropNodes, dropAction, this.relativeMousePos);
    }

    private boolean childGroupAdded(ProgramNode node, Group group) {
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            if (!group.equals(child.getGroup())) continue;
            return true;
        }
        return false;
    }

    private void visitAllNodes(ProgramNode node) {
        if (!node.isModule()) {
            return;
        }
        this.visitNode(node);
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            this.visitAllNodes(child);
        }
    }

    private TreePath getTreePathFromGroup(GroupPath gp) {
        TreePath path = this.findTreePath(gp);
        if (path == null) {
            GroupPath parentgp = null;
            for (parentgp = gp.getParentPath(); parentgp != null && (path = this.findTreePath(parentgp)) == null; parentgp = parentgp.getParentPath()) {
            }
            if (path == null) {
                return null;
            }
            ProgramNode node = (ProgramNode)path.getLastPathComponent();
            if (!node.wasVisited()) {
                this.visitAllNodes(node);
                this.buildNodeList();
            }
            path = this.findTreePath(gp);
        }
        return path;
    }

    private void moveRanges(ProgramFragment destFrag, AddressSetView setView) throws NotFoundException {
        AddressSet view = new AddressSet(setView);
        AddressRangeIterator iter = view.getAddressRanges();
        while (iter.hasNext()) {
            AddressRange range = (AddressRange)iter.next();
            destFrag.move(range.getMinAddress(), range.getMaxAddress());
        }
    }

    private void invalidateTreeParent() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            ((Frame)parent).invalidate();
            return;
        }
    }

    private void mergeFragments(ProgramFragment sourceFragment, ProgramFragment destFragment) throws NotFoundException, NotEmptyException {
        this.moveRanges(destFragment, (AddressSetView)sourceFragment);
        if (sourceFragment.isEmpty()) {
            this.removeEmptyFragment(sourceFragment);
        }
    }

    private void flattenModule(ProgramModule sourceModule, ProgramFragment destFragment) throws NotFoundException, NotEmptyException {
        Group[] groups;
        for (Group group : groups = sourceModule.getChildren()) {
            if (group instanceof ProgramFragment) {
                this.mergeFragments((ProgramFragment)group, destFragment);
                continue;
            }
            this.flattenModule((ProgramModule)group, destFragment);
        }
        if (sourceModule.getNumChildren() == 0) {
            ProgramModule[] parents;
            String name = sourceModule.getName();
            for (ProgramModule parent2 : parents = sourceModule.getParents()) {
                parent2.removeChild(name);
            }
        }
    }

    private void disposeOfNodes() {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            ProgramNode node = this.nodeList.get(i);
            node.dispose();
        }
    }

    private ArrayList<TreePath> getExpandedPaths(ProgramNode node) {
        ArrayList<TreePath> list = new ArrayList<TreePath>();
        int nchild = node.getChildCount();
        for (int i = 0; i < nchild; ++i) {
            ProgramNode child = (ProgramNode)node.getChildAt(i);
            TreePath path = child.getTreePath();
            if (!this.isExpanded(path)) continue;
            list.add(path);
            ArrayList<TreePath> templist = this.getExpandedPaths(child);
            list.addAll(templist);
        }
        return list;
    }

    private String getNewName(String baseName) {
        int index = 2;
        if (this.nameIndexer.get(baseName) < 0 && this.listing.getModule(this.treeName, baseName) == null && this.listing.getFragment(this.treeName, baseName) == null) {
            return baseName;
        }
        boolean done = false;
        while (!done) {
            String name = baseName + " (" + index + ")";
            if (this.nameIndexer.get(name) < 0 && this.listing.getModule(this.treeName, name) == null && this.listing.getFragment(this.treeName, name) == null) {
                return name;
            }
            ++index;
        }
        return null;
    }

    private String generateFragmentName(Address addr) {
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(addr);
        if (symbol == null || symbol.isDynamic()) {
            return addr.toString();
        }
        return symbol.getName();
    }

    private void createRootNode(Program theProgram) {
        if (theProgram == null) {
            this.root = new ProgramNode(null, "No Program");
        } else {
            ProgramModule rm = theProgram.getListing().getRootModule(this.treeName);
            if (rm == null) {
                return;
            }
            this.root = new ProgramNode(theProgram, (Group)rm, rm.getName());
            this.versionTag = rm.getVersionTag();
        }
        this.treeModel.setRoot(this.root);
        this.root.setTree(this);
    }

    private int getChildIndex(ProgramNode parent, Group group) {
        Group[] kids = parent.getModule().getChildren();
        for (int i = 0; i < kids.length; ++i) {
            if (group != kids[i]) continue;
            return i;
        }
        return -1;
    }

    private class NodeComparator
    implements Comparator<TreePath> {
        private NodeComparator() {
        }

        @Override
        public int compare(TreePath p1, TreePath p2) {
            int index2;
            if (p1.equals(p2)) {
                return 0;
            }
            ProgramNode node1 = (ProgramNode)p1.getLastPathComponent();
            ProgramNode node2 = (ProgramNode)p2.getLastPathComponent();
            int index1 = ProgramDnDTree.this.nodeList.indexOf(node1);
            if (index1 < (index2 = ProgramDnDTree.this.nodeList.indexOf(node2))) {
                return -1;
            }
            return 1;
        }
    }
}

