/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.Memory;
import java.io.IOException;
import java.io.InputStream;

class MemoryByteProviderInputStream
extends InputStream {
    private Memory memory;
    private Address startAddress;
    private Address address;

    MemoryByteProviderInputStream(Memory memory, Address address) {
        this.memory = memory;
        this.startAddress = address;
        this.address = address;
    }

    @Override
    public int read() throws IOException {
        try {
            byte b = this.memory.getByte(this.address);
            this.address = this.address.add(1L);
            return b & 0xFF;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int nRead = this.memory.getBytes(this.address, b, off, len);
            this.address = this.address.add((long)len);
            return nRead;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        return (int)this.memory.getMaxAddress().subtract(this.address);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.address = this.startAddress;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.memory = null;
        this.address = null;
    }
}

