/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import ghidra.util.Conv;
import java.io.IOException;

class S_UDT32
extends DebugSymbol {
    private int checksum;
    private byte typeLen;

    static S_UDT32 createS_UDT32(short length, short type, FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        S_UDT32 s_udt32 = (S_UDT32)reader.getFactory().create(S_UDT32.class, new Object[0]);
        s_udt32.initS_UDT32(length, type, reader, ptr);
        return s_udt32;
    }

    private void initS_UDT32(short length, short type, FactoryBundledWithBinaryReader reader, int ptr) throws IOException {
        this.processDebugSymbol(length, type);
        if (type != 4099) {
            throw new IllegalArgumentException("Incorrect type!");
        }
        this.checksum = reader.readInt(ptr);
        this.typeLen = reader.readByte(ptr += 4);
        this.name = reader.readAsciiString(++ptr, Conv.byteToInt((byte)this.typeLen));
    }

    public int getChecksum() {
        return this.checksum;
    }
}

