/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.DialogComponentProvider;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.EmptyBorderButton;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.dialogs.MultiLineMessageDialog;
import docking.widgets.label.GLabel;
import docking.widgets.list.GListCellRenderer;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionValidator;
import ghidra.app.util.OptionsDialog;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.plugin.importer.ImporterLanguageDialog;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import resources.ResourceManager;

public class ImporterDialog
extends DialogComponentProvider {
    public static final String LAST_IMPORTFILE_PREFERENCE_KEY = "Importer.LastFile";
    protected PluginTool tool;
    private ProgramManager programManager;
    protected FSRL fsrl;
    protected List<Option> options;
    private Map<Loader, Collection<LoadSpec>> loadMap;
    protected LanguageCompilerSpecPair selectedLanguage;
    private DomainFolder destinationFolder;
    private boolean languageNeeded;
    private String suggestedDestinationPath;
    protected ByteProvider byteProvider;
    protected JTextField filenameTextField;
    private boolean userHasChangedName;
    protected JButton folderButton;
    protected JButton languageButton;
    protected JTextField languageTextField;
    protected JButton optionsButton;
    protected JTextField folderNameTextField;
    protected GhidraComboBox<Loader> loaderComboBox;

    public ImporterDialog(PluginTool tool, ProgramManager programManager, Map<Loader, Collection<LoadSpec>> loadMap, ByteProvider byteProvider, String suggestedDestinationPath) {
        this("Import " + byteProvider.getFSRL().getPath(), tool, loadMap, byteProvider, suggestedDestinationPath);
        this.programManager = programManager;
    }

    protected ImporterDialog(String title, PluginTool tool, Map<Loader, Collection<LoadSpec>> loadMap, ByteProvider byteProvider, String suggestedDestinationPath) {
        super(title);
        this.tool = tool;
        this.programManager = (ProgramManager)tool.getService(ProgramManager.class);
        this.fsrl = byteProvider.getFSRL();
        this.loadMap = loadMap;
        this.byteProvider = byteProvider;
        this.suggestedDestinationPath = suggestedDestinationPath;
        if (FileSystemService.getInstance().isLocal(this.fsrl)) {
            Preferences.setProperty((String)LAST_IMPORTFILE_PREFERENCE_KEY, (String)this.fsrl.getPath());
        }
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setOkEnabled(false);
        this.setDestinationFolder(this.getProjectRootFolder());
        this.selectedLoaderChanged();
        this.setMinimumSize(new Dimension(500, this.getPreferredSize().height));
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("ImporterPlugin", "Importer_Dialog"));
    }

    public void setDestinationFolder(DomainFolder folder) {
        this.destinationFolder = folder;
        this.folderNameTextField.setText(this.destinationFolder.toString());
        this.validateFormInput();
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildMainPanel());
        panel.add(this.buildButtonPanel());
        return panel;
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel("Format: ", 4));
        panel.add(this.buildLoaderChooser());
        panel.add((Component)new GLabel("Language: ", 4));
        panel.add(this.buildLanguagePanel());
        panel.add((Component)new GLabel("Destination Folder: ", 4));
        panel.add(this.buildFolderPanel());
        panel.add((Component)new GLabel("Program Name: ", 4));
        panel.add(this.buildFilenameTextField());
        return panel;
    }

    private Component buildFilenameTextField() {
        this.filenameTextField = new JTextField();
        this.filenameTextField.setText(this.getSuggestedFilename());
        this.filenameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ImporterDialog.this.userHasChangedName = true;
            }
        });
        this.filenameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImporterDialog.this.validateFormInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImporterDialog.this.validateFormInput();
            }
        });
        return this.filenameTextField;
    }

    private String getSuggestedFilename() {
        Loader loader = this.getSelectedLoader();
        if (loader != null) {
            return loader.getPreferredFileName(this.byteProvider);
        }
        return this.fsrl.getName();
    }

    private Component buildFolderPanel() {
        this.folderNameTextField = new JTextField();
        this.folderNameTextField.setEditable(false);
        this.folderNameTextField.setFocusable(false);
        this.folderButton = ButtonPanelFactory.createButton((int)2);
        this.folderButton.addActionListener(e -> this.chooseProjectFolder());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.folderNameTextField, "Center");
        panel.add((Component)this.folderButton, "East");
        return panel;
    }

    private JComponent buildLanguagePanel() {
        this.languageTextField = new JTextField();
        this.languageTextField.setEditable(false);
        this.languageTextField.setFocusable(false);
        this.languageButton = ButtonPanelFactory.createButton((int)2);
        this.languageButton.addActionListener(e -> {
            Object selectedItem = this.loaderComboBox.getSelectedItem();
            if (selectedItem instanceof Loader) {
                Loader loader = (Loader)selectedItem;
                ImporterLanguageDialog dialog = new ImporterLanguageDialog(this.loadMap.get(loader), this.tool, this.selectedLanguage);
                dialog.show(this.getComponent());
                LanguageCompilerSpecPair dialogResult = dialog.getSelectedLanguage();
                if (dialogResult != null) {
                    this.setSelectedLanguage(dialogResult);
                }
            }
            this.validateFormInput();
        });
        Font font = this.languageButton.getFont();
        this.languageButton.setFont(new Font(font.getName(), 1, font.getSize()));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.languageTextField, "Center");
        panel.add((Component)this.languageButton, "East");
        return panel;
    }

    private Component buildLoaderChooser() {
        JPanel panel = new JPanel(new BorderLayout());
        LinkedHashSet<Loader> set = new LinkedHashSet<Loader>();
        for (Loader loader2 : this.loadMap.keySet()) {
            if (!this.isSupported(loader2)) continue;
            set.add(loader2);
        }
        this.loaderComboBox = new GhidraComboBox(new Vector(set));
        this.loaderComboBox.addItemListener(e -> this.selectedLoaderChanged());
        this.loaderComboBox.setEnterKeyForwarding(true);
        this.loaderComboBox.setRenderer((ListCellRenderer)GListCellRenderer.createDefaultCellTextRenderer(loader -> loader.getName()));
        if (!set.isEmpty()) {
            this.loaderComboBox.setSelectedIndex(0);
        }
        panel.add((Component)this.loaderComboBox, "Center");
        panel.add(this.buildLoaderInfoButton(), "East");
        return panel;
    }

    private Component buildLoaderInfoButton() {
        JPanel panel = new JPanel(new BorderLayout());
        EmptyBorderButton helpButton = new EmptyBorderButton((Icon)ResourceManager.loadImage((String)"images/information.png"));
        helpButton.setToolTipText("Show list of supported format/loaders");
        helpButton.addActionListener(e -> this.showSupportedImportFormats());
        panel.add((Component)helpButton);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        return panel;
    }

    private void showSupportedImportFormats() {
        String s = LoaderService.getAllLoaderNames().stream().collect(Collectors.joining("\n"));
        MultiLineMessageDialog.showModalMessageDialog(null, (String)"Supported Formats", null, (String)s, (int)-1);
    }

    protected boolean isSupported(Loader loader) {
        return true;
    }

    protected void selectedLoaderChanged() {
        Loader loader = (Loader)this.loaderComboBox.getItemAt(this.loaderComboBox.getSelectedIndex());
        if (loader != null) {
            this.languageNeeded = this.isLanguageNeeded(loader);
            this.setSelectedLanguage(this.getPreferredLanguage(loader));
            if (this.suggestedDestinationPath != null) {
                this.setFilename(FSUtilities.appendPath(this.suggestedDestinationPath, this.getSuggestedFilename()));
            } else {
                this.setFilename(this.getSuggestedFilename());
            }
        } else {
            this.languageNeeded = true;
            this.setSelectedLanguage(null);
        }
        this.options = null;
        this.validateFormInput();
    }

    private boolean isLanguageNeeded(Loader loader) {
        return this.loadMap.get(loader).stream().anyMatch(spec -> spec.requiresLanguageCompilerSpec());
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        innerPanel.add(this.buildOptionsButton());
        panel.add((Component)innerPanel, "East");
        return panel;
    }

    private Component buildOptionsButton() {
        this.optionsButton = new JButton("Options...");
        this.optionsButton.addActionListener(e -> this.showOptions());
        return this.optionsButton;
    }

    protected void okCallback() {
        if (this.validateFormInput()) {
            Loader loader = this.getSelectedLoader();
            LoadSpec loadSpec = this.getSelectedLoadSpec(loader);
            String programPath = this.removeTrailingSlashes(this.getName());
            DomainFolder importFolder = this.getOrCreateImportFolder(this.destinationFolder, programPath);
            String programName = FilenameUtils.getName((String)programPath);
            this.options = this.getOptions(loadSpec);
            TaskLauncher.launchNonModal((String)"Import File", monitor -> ImporterUtilities.importSingleFile(this.tool, this.programManager, this.fsrl, importFolder, loadSpec, programName, this.options, monitor));
            this.close();
        }
    }

    private String removeTrailingSlashes(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private DomainFolder getOrCreateImportFolder(DomainFolder parentFolder, String programPath) {
        int lastIndexOf = programPath.lastIndexOf("/");
        if (lastIndexOf < 0) {
            return parentFolder;
        }
        String folderPath = programPath.substring(0, lastIndexOf);
        try {
            return ProjectDataUtils.createDomainFolderPath((DomainFolder)parentFolder, (String)folderPath);
        }
        catch (InvalidNameException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error Creating Folders", (Object)e.getMessage());
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Error Creating Folders", (Object)("I/O Error" + e.getMessage()), (Throwable)e);
        }
        return parentFolder;
    }

    public void close() {
        super.close();
        try {
            this.byteProvider.close();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Unexpected exception closing byte provider.", (Object)e);
        }
    }

    protected List<Option> getOptions(LoadSpec loadSpec) {
        if (this.options == null) {
            this.options = loadSpec.getLoader().getDefaultOptions(this.byteProvider, loadSpec, null, false);
        }
        return this.options;
    }

    private void showOptions() {
        try {
            Loader loader = this.getSelectedLoader();
            AddressFactory addressFactory = this.selectedLanguage.getLanguage().getAddressFactory();
            LoadSpec loadSpec = this.getSelectedLoadSpec(loader);
            OptionValidator validator = optionList -> loader.validateOptions(this.byteProvider, loadSpec, optionList, null);
            AddressFactoryService service = () -> addressFactory;
            List<Option> currentOptions = this.getOptions(loadSpec);
            if (currentOptions.isEmpty()) {
                Msg.showInfo((Object)((Object)this), null, (String)"Options", (Object)"There are no options for this importer!");
                return;
            }
            OptionsDialog optionsDialog = new OptionsDialog(currentOptions, validator, service);
            optionsDialog.setHelpLocation(new HelpLocation("ImporterPlugin", this.getAnchorForSelectedLoader(loader)));
            this.tool.showDialog((DialogComponentProvider)optionsDialog);
            if (!optionsDialog.wasCancelled()) {
                this.options = optionsDialog.getOptions();
            }
            this.validateFormInput();
        }
        catch (LanguageNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Language Error", (Object)("Can't get the language for " + this.selectedLanguage));
        }
    }

    private String getAnchorForSelectedLoader(Loader loader) {
        return "Options_" + loader.getName();
    }

    protected LoadSpec getSelectedLoadSpec(Loader loader) {
        Collection<LoadSpec> loadSpecs = this.loadMap.get(loader);
        long imageBase = 0L;
        if (loadSpecs != null && !loadSpecs.isEmpty()) {
            imageBase = loadSpecs.iterator().next().getDesiredImageBase();
        }
        return new LoadSpec(loader, imageBase, this.selectedLanguage, false);
    }

    protected Loader getSelectedLoader() {
        return (Loader)this.loaderComboBox.getSelectedItem();
    }

    protected boolean validateFormInput() {
        this.setOkEnabled(false);
        this.languageButton.setEnabled(this.languageNeeded);
        this.optionsButton.setEnabled(false);
        if (this.loaderComboBox.getSelectedIndex() == -1) {
            this.setStatusText("Please select a format.");
            return false;
        }
        if (this.languageNeeded && this.selectedLanguage == null) {
            this.setStatusText("Please select a language.");
            return false;
        }
        this.optionsButton.setEnabled(this.selectedLanguage != null);
        if (!this.validateFilename()) {
            return false;
        }
        this.setStatusText("");
        this.setOkEnabled(true);
        return true;
    }

    private boolean validateFilename() {
        if (this.getName().isEmpty()) {
            this.setStatusText("Please enter a destination file name.");
            return false;
        }
        if (this.warnedAboutInvalidFilenameChars()) {
            return false;
        }
        if (this.isMissingFilename()) {
            this.setStatusText("Destination path does not specify filename.");
            return false;
        }
        if (this.isDuplicateFilename()) {
            this.setStatusText("Destination file name already exists.");
            return false;
        }
        if (this.isFilenameTooLong()) {
            this.setStatusText("Destination file name is too long. ( >" + this.tool.getProject().getProjectData().getMaxNameLength() + ")");
            return false;
        }
        return true;
    }

    private boolean warnedAboutInvalidFilenameChars() {
        String filename = this.getName();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            if (LocalFileSystem.isValidNameCharacter((char)ch) || ch == '/') continue;
            this.setStatusText("Invalid character " + ch + " in filename.");
            return true;
        }
        return false;
    }

    private boolean isMissingFilename() {
        String filename = FilenameUtils.getName((String)this.getName());
        return StringUtils.isBlank((CharSequence)filename);
    }

    private boolean isDuplicateFilename() {
        DomainFolder localDestFolder;
        String pathFilename = this.getName();
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)pathFilename);
        String filename = FilenameUtils.getName((String)pathFilename);
        DomainFolder domainFolder = localDestFolder = parentPath != null ? ProjectDataUtils.lookupDomainPath((DomainFolder)this.destinationFolder, (String)parentPath) : this.destinationFolder;
        return localDestFolder != null && (localDestFolder.getFolder(filename) != null || localDestFolder.getFile(filename) != null);
    }

    private boolean isFilenameTooLong() {
        String fullPath;
        int maxNameLen = this.tool.getProject().getProjectData().getMaxNameLength();
        String currentPath = fullPath = this.getName();
        while (!StringUtils.isBlank((CharSequence)currentPath)) {
            String filename = FilenameUtils.getName((String)currentPath);
            if (filename.isEmpty()) {
                return false;
            }
            if (filename.length() >= maxNameLen) {
                return true;
            }
            currentPath = FilenameUtils.getFullPathNoEndSeparator((String)currentPath);
        }
        return false;
    }

    private String getName() {
        return this.filenameTextField.getText().trim();
    }

    private void setFilename(String s) {
        if (this.userHasChangedName && this.validateFilename()) {
            return;
        }
        this.filenameTextField.setText(s);
    }

    protected void setSelectedLanguage(LanguageCompilerSpecPair lcsPair) {
        this.selectedLanguage = lcsPair;
        if (this.selectedLanguage == null) {
            this.languageTextField.setText("");
        } else {
            this.languageTextField.setText(this.selectedLanguage.toString());
        }
    }

    private LanguageCompilerSpecPair getPreferredLanguage(Loader loader) {
        for (LoadSpec loadSpec : this.loadMap.get(loader)) {
            if (!loadSpec.isPreferred()) continue;
            return loadSpec.getLanguageCompilerSpec();
        }
        return null;
    }

    private DomainFolder getProjectRootFolder() {
        Project project = AppInfo.getActiveProject();
        ProjectData projectData = project.getProjectData();
        return projectData.getRootFolder();
    }

    private void chooseProjectFolder() {
        DataTreeDialog dataTreeDialog = new DataTreeDialog(this.getComponent(), "Choose a project folder", 2);
        dataTreeDialog.setSelectedFolder(this.destinationFolder);
        dataTreeDialog.showComponent();
        DomainFolder folder = dataTreeDialog.getDomainFolder();
        if (folder != null) {
            this.setDestinationFolder(folder);
        }
    }

    JComboBox<Loader> getFormatComboBox() {
        return this.loaderComboBox;
    }

    JTextField getLanguageTextField() {
        return this.languageTextField;
    }

    JTextField getFilenameTextField() {
        return this.filenameTextField;
    }
}

