/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.memory;

import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;
import java.util.Objects;

public class MemSearchResult
implements Comparable<MemSearchResult> {
    private Address address;
    private int length;

    public MemSearchResult(Address address, int length) {
        this.address = Objects.requireNonNull(address);
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be greater than 0");
        }
        this.length = length;
    }

    public Address getAddress() {
        return this.address;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int compareTo(MemSearchResult o) {
        return this.address.compareTo((Object)o.address);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemSearchResult other = (MemSearchResult)obj;
        return SystemUtilities.isEqual((Object)this.address, (Object)other.address);
    }

    public String toString() {
        return this.address.toString();
    }

    public boolean addressEquals(Address a) {
        return this.address.equals((Object)a);
    }
}

