/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state.analysis;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.state.analysis.RelativeJumpTableSwitch;
import ghidra.util.state.analysis.TableEntry;
import ghidra.util.state.analysis.TableEntryAddress;

public abstract class Switch {
    abstract Address getCaseAddress(int var1) throws MemoryAccessException, AddressOutOfBoundsException;

    abstract Varnode getIndexValue();

    static Switch getIndirectJumpSwitch(Program program, Varnode v) {
        if (!(v instanceof VarnodeOperation)) {
            return null;
        }
        VarnodeOperation op = (VarnodeOperation)v;
        int opcode = op.getPCodeOp().getOpcode();
        if (opcode == 2) {
            TableEntry tableEntry = TableEntry.getTableEntry(program, op);
            if (tableEntry != null) {
                return tableEntry;
            }
            return null;
        }
        if (opcode == 19) {
            RelativeJumpTableSwitch relJumpTableSwitch = RelativeJumpTableSwitch.getRelativeJumpTableSwitch(program, op);
            if (relJumpTableSwitch != null) {
                return relJumpTableSwitch;
            }
            return TableEntryAddress.getTableEntryAddress(program.getAddressFactory(), op);
        }
        return null;
    }
}

