/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.component.ClangHighlightListener;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ClangHighlightController {
    protected Color defaultNonFunctionBackgroundColor = new Color(220, 220, 220);
    protected Color defaultHighlightColor = new Color(255, 255, 0, 128);
    protected Color defaultSpecialColor = new Color(255, 100, 0, 128);
    protected Color defaultParenColor = new Color(255, 255, 0, 128);
    protected HashSet<ClangToken> highlightTokenSet = new HashSet();
    protected ArrayList<ClangHighlightListener> highlightListenerList = new ArrayList();

    public abstract void fieldLocationChanged(FieldLocation var1, Field var2, EventTrigger var3);

    void loadOptions(DecompileOptions options) {
        Color currentVariableHighlightColor = options.getCurrentVariableHighlightColor();
        if (currentVariableHighlightColor != null) {
            this.setDefaultHighlightColor(currentVariableHighlightColor);
        }
    }

    public void setDefaultHighlightColor(Color highlightColor) {
        this.defaultHighlightColor = highlightColor;
        this.notifyListeners();
    }

    public void setDefaultSpecialColor(Color specialColor) {
        this.defaultSpecialColor = specialColor;
        this.notifyListeners();
    }

    public void setDefaultParenColor(Color parenColor) {
        this.defaultParenColor = parenColor;
        this.notifyListeners();
    }

    public Color getDefaultHighlightColor() {
        return this.defaultHighlightColor;
    }

    public Color getDefaultSpecialColor() {
        return this.defaultSpecialColor;
    }

    public Color getDefaultParenColor() {
        return this.defaultParenColor;
    }

    public String getHighlightedText() {
        ClangToken highlightedToken = this.getHighlightedToken();
        if (highlightedToken != null) {
            return highlightedToken.getText();
        }
        return null;
    }

    public ClangToken getHighlightedToken() {
        if (this.highlightTokenSet.size() == 1) {
            ClangToken[] tokenArray = this.highlightTokenSet.toArray(new ClangToken[this.highlightTokenSet.size()]);
            return tokenArray[0];
        }
        return null;
    }

    public void addVarnodesToHighlight(ClangNode parentNode, Set<Varnode> varnodes, Color highlightColor, Varnode specificvn, PcodeOp specificop, Color specialColor) {
        int nchild = parentNode.numChildren();
        for (int i = 0; i < nchild; ++i) {
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                this.addVarnodesToHighlight(node, varnodes, highlightColor, specificvn, specificop, specialColor);
                continue;
            }
            if (!(node instanceof ClangToken)) continue;
            ClangToken tok = (ClangToken)node;
            Varnode vn = DecompilerUtils.getVarnodeRef(tok);
            if (varnodes.contains(vn)) {
                this.addHighlight(tok, highlightColor);
            }
            if (vn != specificvn || specificop == null || tok.getPcodeOp() != specificop) continue;
            this.addHighlight(tok, specialColor);
        }
        this.notifyListeners();
    }

    public void addPcodeOpsToHighlight(ClangNode parentNode, Set<PcodeOp> ops, Color highlightColor) {
        int nchild = parentNode.numChildren();
        for (int i = 0; i < nchild; ++i) {
            ClangToken tok;
            PcodeOp op;
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                this.addPcodeOpsToHighlight(node, ops, highlightColor);
                continue;
            }
            if (!(node instanceof ClangToken) || !ops.contains(op = (tok = (ClangToken)node).getPcodeOp())) continue;
            this.addHighlight(tok, highlightColor);
        }
        this.notifyListeners();
    }

    public void addTokensToHighlights(List<ClangToken> tokenList, Color highlightColor) {
        for (ClangToken clangToken : tokenList) {
            this.doAddHighlight(clangToken, highlightColor);
        }
        this.notifyListeners();
    }

    public void clearHighlights() {
        for (ClangToken clangToken : this.highlightTokenSet) {
            clangToken.setHighlight(null);
            if (!clangToken.isMatchingToken()) continue;
            clangToken.setMatchingToken(false);
        }
        this.highlightTokenSet.clear();
        this.notifyListeners();
    }

    public void addHighlight(ClangToken clangToken, Color highlightColor) {
        this.doAddHighlight(clangToken, highlightColor);
        this.notifyListeners();
    }

    public void doAddHighlight(ClangToken clangToken, Color highlightColor) {
        clangToken.setHighlight(highlightColor);
        this.highlightTokenSet.add(clangToken);
    }

    public void clearHighlight(ClangToken clangToken) {
        clangToken.setHighlight(null);
        this.highlightTokenSet.remove(clangToken);
        this.notifyListeners();
    }

    public boolean isHighlighted(ClangToken clangToken) {
        return this.highlightTokenSet.contains(clangToken);
    }

    public List<ClangToken> addHighlightParen(ClangSyntaxToken tok, Color highlightColor) {
        ArrayList<ClangToken> tokenList = new ArrayList<ClangToken>();
        int paren = tok.getOpen();
        if (paren == -1) {
            paren = tok.getClose();
        }
        if (paren == -1) {
            return tokenList;
        }
        for (ClangNode par = tok.Parent(); par != null; par = par.Parent()) {
            boolean outside = true;
            if (!(par instanceof ClangTokenGroup)) continue;
            ArrayList<ClangNode> list = new ArrayList<ClangNode>();
            ((ClangTokenGroup)par).flatten(list);
            for (int i = 0; i < list.size(); ++i) {
                ClangToken tk = (ClangToken)list.get(i);
                if (tk instanceof ClangSyntaxToken) {
                    ClangSyntaxToken syn = (ClangSyntaxToken)tk;
                    if (syn.getOpen() == paren) {
                        outside = false;
                    } else if (syn.getClose() == paren) {
                        outside = true;
                        this.addHighlight(syn, highlightColor);
                        tokenList.add(syn);
                    }
                }
                if (outside) continue;
                this.addHighlight(tk, highlightColor);
                tokenList.add(tk);
            }
        }
        return tokenList;
    }

    public void addHighlightBrace(ClangSyntaxToken token, Color highlightColor) {
        if (DecompilerUtils.isBrace(token)) {
            this.highlightBrace(token, highlightColor);
            this.notifyListeners();
        }
    }

    private void highlightBrace(ClangSyntaxToken startToken, Color highlightColor) {
        ClangSyntaxToken matchingBrace = DecompilerUtils.getMatchingBrace(startToken);
        if (matchingBrace != null) {
            matchingBrace.setMatchingToken(true);
            this.addHighlight(matchingBrace, highlightColor);
        }
    }

    public void addHighlightFill() {
        ClangTokenGroup lastgroup = null;
        ArrayList<ClangNode> newhi = new ArrayList<ClangNode>();
        ArrayList<Color> newcolor = new ArrayList<Color>();
        for (ClangToken tok : this.highlightTokenSet) {
            ClangTokenGroup par;
            if (!(tok.Parent() instanceof ClangTokenGroup) || (par = (ClangTokenGroup)tok.Parent()) == lastgroup) continue;
            lastgroup = par;
            int beg = -1;
            int end = par.numChildren();
            for (int j = 0; j < par.numChildren(); ++j) {
                if (par.Child(j) instanceof ClangToken) {
                    ClangToken token = (ClangToken)par.Child(j);
                    Color curcolor = token.getHighlight();
                    if (curcolor != null) {
                        if (beg == -1) {
                            beg = j;
                            continue;
                        }
                        end = j;
                        for (int k = beg + 1; k < end; ++k) {
                            if (!(par.Child(k) instanceof ClangToken)) continue;
                            newhi.add(par.Child(k));
                            newcolor.add(curcolor);
                        }
                        beg = j;
                        continue;
                    }
                    if (token.getMinAddress() == null) continue;
                    beg = -1;
                    continue;
                }
                beg = -1;
            }
        }
        for (int i = 0; i < newhi.size(); ++i) {
            ClangToken tok;
            tok = (ClangToken)newhi.get(i);
            if (tok.getHighlight() != null) continue;
            this.addHighlight(tok, (Color)newcolor.get(i));
        }
        this.notifyListeners();
    }

    public boolean addListener(ClangHighlightListener listener) {
        return this.highlightListenerList.add(listener);
    }

    public boolean removeListener(ClangHighlightListener listener) {
        return this.highlightListenerList.remove(listener);
    }

    private void notifyListeners() {
        for (ClangHighlightListener listener : this.highlightListenerList) {
            listener.tokenHighlightsChanged();
        }
    }
}

