/*
 * Decompiled with CFR 0.152.
 */
package pdb;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.dialogs.ObjectChooserDialog;
import docking.widgets.label.GDLabel;
import generic.jar.ResourceFile;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.framework.preferences.Preferences;
import ghidra.util.MessageType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import pdb.URLChoice;

public class AskPdbUrlDialog
extends DialogComponentProvider {
    private boolean isCanceled;
    private JLabel label;
    private JTextField textField;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 10) {
                AskPdbUrlDialog.this.okCallback();
            }
        }
    };
    private List<URLChoice> choices = null;

    protected AskPdbUrlDialog(String dialogTitle, String message) {
        this(null, dialogTitle, message, null);
    }

    public AskPdbUrlDialog(String dialogTitle, String message, Object defaultValue) {
        this(null, dialogTitle, message, defaultValue);
    }

    public AskPdbUrlDialog(Component parent, String title, String message) {
        this(parent, title, message, null);
    }

    public AskPdbUrlDialog(Component parent, String title, String message, Object defaultValue) {
        super(title, true, true, true, false);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.label = new GDLabel(message);
        panel.add((Component)this.label, "West");
        this.textField = new JTextField(40);
        this.textField.setName("JTextField");
        this.textField.addKeyListener(this.keyListener);
        this.textField.setText(defaultValue == null ? "" : defaultValue.toString());
        this.textField.selectAll();
        panel.add((Component)this.textField, "Center");
        if (this.urlFileAvailable()) {
            JButton urlButton = new JButton("Choose from known URLs");
            urlButton.addActionListener(e -> this.urlCallback());
            panel.add((Component)urlButton, "East");
        }
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
        if (SwingUtilities.isEventDispatchThread()) {
            DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
        } else {
            try {
                SwingUtilities.invokeAndWait(() -> DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this));
            }
            catch (InterruptedException | InvocationTargetException exception) {
                // empty catch block
            }
        }
    }

    protected void addOKButton() {
        this.okButton = new JButton("Download from URL");
        this.okButton.setMnemonic('K');
        this.okButton.setName("OK");
        this.okButton.addActionListener(e -> this.okCallback());
        this.addButton(this.okButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean urlFileAvailable() {
        List urlFiles = Application.findFilesByExtensionInApplication((String)".pdburl");
        if (urlFiles.size() == 0) {
            return false;
        }
        try {
            InputStream urlFileContents = null;
            this.choices = new ArrayList<URLChoice>();
            for (ResourceFile urlFile : urlFiles) {
                urlFileContents = urlFile.getInputStream();
                try (Scanner scanner = new Scanner(urlFileContents);){
                    while (scanner.hasNextLine()) {
                        String currentLine = scanner.nextLine();
                        int commaIndex = currentLine.indexOf(44);
                        if (commaIndex <= -1) continue;
                        this.choices.add(new URLChoice(currentLine.substring(0, commaIndex).trim(), currentLine.substring(commaIndex + 1).trim()));
                    }
                }
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    private void saveCurrentDimensions() {
        Rectangle bounds = this.getBounds();
        Window window = WindowUtilities.windowForComponent((Component)this.getComponent());
        if (window != null) {
            Point location = window.getLocation();
            bounds.x = location.x;
            bounds.y = location.y;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(bounds.x).append(":");
        buffer.append(bounds.y).append(":");
        buffer.append(bounds.width).append(":");
        buffer.append(bounds.height).append(":");
        Preferences.setProperty((String)"Ask Dialog Bounds", (String)buffer.toString());
    }

    public Object getValue() {
        return this.textField.getText();
    }

    protected void okCallback() {
        this.isCanceled = false;
        if (this.textField.getText().length() == 0) {
            this.setStatusText("Please enter a valid URL.");
            return;
        }
        this.saveCurrentDimensions();
        this.close();
    }

    protected void cancelCallback() {
        this.isCanceled = true;
        this.saveCurrentDimensions();
        this.close();
    }

    private void urlCallback() {
        ObjectChooserDialog urlDialog = new ObjectChooserDialog("Choose a URL", URLChoice.class, this.choices, new String[]{"getNetwork", "getUrl"});
        DockingWindowManager activeInstance = DockingWindowManager.getActiveInstance();
        DockingWindowManager.showDialog((DialogComponentProvider)urlDialog);
        URLChoice pickedUrl = (URLChoice)urlDialog.getSelectedObject();
        if (pickedUrl != null) {
            this.textField.setText(pickedUrl.getUrl());
            if (pickedUrl.getNetwork().equalsIgnoreCase("internet")) {
                this.setStatusText("WARNING: Check your organization's security policy before downloading files from the internet.", MessageType.ERROR);
            } else {
                this.setStatusText(null);
            }
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getValueAsString() {
        Object val = this.getValue();
        if ("".equals(val)) {
            return null;
        }
        return val != null ? val.toString() : null;
    }
}

